% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reparam_curve.R
\name{reparam_curve}
\alias{reparam_curve}
\title{Align two curves}
\usage{
reparam_curve(beta1, beta2, lambda = 0, method = "DP", w = 0.01,
  rotated = T, isclosed = F)
}
\arguments{
\item{beta1}{array defining curve 1}

\item{beta2}{array defining curve 1}

\item{lambda}{controls amount of warping (default = 0)}

\item{method}{controls which optimization method (default="DP") options are
Dynamic Programming ("DP"), Coordinate Descent ("DP2"), Riemannian BFGS
("RBFGS")}

\item{w}{controls LRBFGS (default = 0.01)}

\item{rotated}{boolean if rotation is desired}

\item{isclosed}{boolean if curve is closed}
}
\value{
return a List containing \item{gam}{warping function}
\item{R}{rotation matrix}
\item{tau}{seed point}
}
\description{
This function aligns two SRVF functions using Dynamic Programming
}
\examples{
data("mpeg7")
gam = reparam_curve(beta[,,1,1],beta[,,1,5])$gam
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape analysis of elastic curves in euclidean spaces. Pattern Analysis and Machine Intelligence, IEEE Transactions on 33 (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}
