% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_principal_directions.R
\name{curve_principal_directions}
\alias{curve_principal_directions}
\title{Curve PCA}
\usage{
curve_principal_directions(betamean, mu, K, mode = "O", no = 3,
  N = 5)
}
\arguments{
\item{betamean}{array (n,T) of mean curve}

\item{mu}{array (n,T) of mean srvf}

\item{K}{array (2*T,2*T) covariance matrix}

\item{mode}{Open ("O") or Closed ("C") curves}

\item{no}{number of components}

\item{N}{number of samples on each side of mean}
}
\value{
pd list describing principal directions
}
\description{
Calculate principal directions of a set of curves
}
\examples{
data("mpeg7")
out = curve_srvf_align(beta[,,1,1:2],maxit=2) # note: use more shapes, small for speed
K = curve_karcher_cov(out$betamean, beta[,,1,1:2])
pd = curve_principal_directions(out$betamean, out$q_mu, K)
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape analysis of elastic curves in euclidean spaces. Pattern Analysis and Machine Intelligence, IEEE Transactions on 33 (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}
