% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{RANDOMFOREST}
\alias{RANDOMFOREST}
\title{Classification using Random Forest}
\usage{
RANDOMFOREST(
  train,
  labels,
  ntree = 500,
  nvar = if (!is.null(labels) && !is.factor(labels)) max(floor(ncol(train)/3), 1) else
    floor(sqrt(ncol(train))),
  tune = FALSE,
  ...
)
}
\arguments{
\item{train}{The training set (description), as a \code{data.frame}.}

\item{labels}{Class labels of the training set (\code{vector} or \code{factor}).}

\item{ntree}{The number of trees in the forest.}

\item{nvar}{Number of variables randomly sampled as candidates at each split.}

\item{tune}{If true, the function returns paramters instead of a classification model.}

\item{...}{Other parameters.}
}
\value{
The classification model.
}
\description{
This function builds a classification model using Random Forest
}
\examples{
require (datasets)
data (iris)
RANDOMFOREST (iris [, -5], iris [, 5])
}
\seealso{
\code{\link[randomForest]{randomForest}}
}
