% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{predict.kmeans}
\alias{predict.kmeans}
\title{Predict function for K-means}
\usage{
\method{predict}{kmeans}(object, newdata, ...)
}
\arguments{
\item{object}{The classification model (created by \code{\link{KMEANS}}).}

\item{newdata}{A new dataset (a \code{data.frame}), with same variables as the learning dataset.}

\item{...}{Other parameters.}
}
\description{
Return the closest K-means cluster for a new dataset.
}
\examples{
require (datasets)
data (iris)
d = splitdata (iris, 5)
model = KMEANS (d$train.x, k = 3)
predict (model, d$test.x)
}
\seealso{
\code{\link{KMEANS}}
}
