% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/fedstat_prepare_reference_data_for_check_data_update.R
\name{fedstat_prepare_reference_data_for_check_data_update}
\alias{fedstat_prepare_reference_data_for_check_data_update}
\title{Loads the data that will be used to compare with the new data to detect data updates}
\usage{
fedstat_prepare_reference_data_for_check_data_update(
  indicator_id,
  ...,
  filters = list(),
 
    time_filter_fields_titles = c("\\\\u041f\\\\u0435\\\\u0440\\\\u0438\\\\u043e\\\\u0434",
    "\\\\u0413\\\\u043e\\\\u0434"),
  time_fields_titles_in_df = c("PERIOD", "Time"),
  filter_value_title_alias_lookup_table = data.frame(filter_value_title = character(),
    filter_value_title_alias = character(), stringsAsFactors = FALSE),
  timeout_seconds = 180,
  retry_max_times = 3,
  disable_warnings = FALSE,
  httr_verbose = httr::verbose(data_out = FALSE)
)
}
\arguments{
\item{indicator_id}{character, indicator id/code from indicator URL.
For example for indicator with URL https://www.fedstat.ru/indicator/37426 indicator id will be 37426}

\item{...}{other arguments passed to httr::GET and httr::POST}

\item{filters}{JSON in R list form. The structure should be like this:

\preformatted{
{
 "filter_field_title1": ["filter_value_title1", "filter_value_title2"],
 "filter_field_title2": ["filter_value_title1", "filter_value_title2"],
 ...
}
}

Where for example \code{filter_field_title1} could be a string "Year" with
\code{filter_value_title1} equal to 2020 and \code{filter_field_title2}
could be a string "OKATO" with \code{filter_value_title1}
equal to "Russian Federation"
Not actual filter field titles and filter values titles
because of ASCII requirement for CRAN}

\item{time_filter_fields_titles}{character, title names of time filter fields
in \code{filters} list, currently only default values are allowed}

\item{time_fields_titles_in_df}{character, title names of time related columns
in \code{data_df} (result of \code{fedstat_parse_sdmx_to_table}), currently only default values are allowed}

\item{filter_value_title_alias_lookup_table}{data.frame with columns \code{filter_value_title} and \code{filter_value_title_alias}.
Used to replace \code{filter_value_title} with standard forms of filter value titles.
It is mainly used to set consistent names.
For example, the Dalnevostochnyj federalnyj okrug ( s 03.11.2018) (transliteration for CRAN) in \code{filter_value_title}
can be simply replaced with \code{filter_value_title_alias} as Dalnevostochnyj federalnyj okrug.
In this example in fact, these are two different entities (after the inclusion of Buryatia and Transbaikalia and before),
but in most cases such a replacement is more convenient for loading data, since you need the whole time series.
By default it's empty data.frame, e.g. no replacement for anything.}

\item{timeout_seconds}{numeric, maximum time before a new GET and POST request is tried}

\item{retry_max_times}{numeric, maximum number of tries to GET and POST \code{data_ids}}

\item{disable_warnings}{bool, enables or disables following warnings:
\enumerate{
\item About non matched \code{filter_value_title} in \code{filters} and \code{filter_value_title} from \code{data_ids};
\item About unspecified \code{filter_filed_title} in filters.
}}

\item{httr_verbose}{\code{httr::verbose()} or NULL, outputs messages to the console
about the processing of the request}
}
\value{
list with the following fields: indicator_id,
filters,
time_filter_fields_titles,
time_fields_titles_in_df,
filter_value_title_alias_lookup_table,
reference_data_ids_unfiltered_special_cases_handled,
reference_data_df
}
\description{
Used only as a first argument in \link{fedstat_check_data_update}.
Stores the original filters, data_ids, data_df and other arguments.
Combines it all into one object, which ensures that filters and other
arguments are identical for old and new data queries.

You \emph{shouldn't} specify time filters in \code{filters} list.
This function does this automatically, it takes all PERIODs and the last year.

Please try to specify filters as much as possible
(for example, using filters only for Russia and a certain type of
indicator/good/service, etc.),
it will reduce the query execution time and server load on fedstat.ru.
You don't need all the data to check the data updates anyway,
one observation with the new date is enough. However, keep in mind that you
need to choose observations that are sure to be in the new data release.
}
\examples{
\dontrun{
reference_data <- fedstat_prepare_reference_data_for_check_data_update(
  indicator_id = "37426",
  filters = list(
    "Territory" = "Russian Federation",
    "Types of goods and services" = "Sahar-pesok, kg"
  )
)
# Not actual filter field titles and filter values titles because of ASCII requirement for CRAN
}
}
