###################################################
### chunk number 1: 
###################################################

library(femmeR)



###################################################
### chunk number 2: 
###################################################
test <- read.st1("ENHDIFF1.ST1")

plot(test)



###################################################
### chunk number 3: 
###################################################

plot(test,xvari=2,yvari=1,rev="y",xlab="Radon (dpm/dm3)")



###################################################
### chunk number 4: 
###################################################

test.obs <- read.obs("sep.obs")
plot(test,xvari=1,yvari=2,rev="vx",obs=test.obs)




###################################################
### chunk number 5: 
###################################################
test.o1 <- read.o1("DILUTIONIRRIGATION.O1")
plot(test.o1,xvar=1,yvar=3)



###################################################
### chunk number 6: 
###################################################
plot(test.o1,xvari="TIME",yvari=3)




###################################################
### chunk number 7: varlist
###################################################
test.o1



###################################################
### chunk number 8: 
###################################################
plot(test.o1,xvar=1,yvari=c(3,5,8,10),main="")



###################################################
### chunk number 9: 1Da
###################################################
test.o2 <- read.o2("BERG.O2")



###################################################
### chunk number 10: 1Db
###################################################
plot(test.o2,zvari=3,rev="y")



###################################################
### chunk number 11: 1dC
###################################################
plot(test.o2,zvari=3,ylim=c(10,0),ylab="Depth (cm)",xlab="Time (h)",linecol="white",labcex=1,lty=2)



###################################################
### chunk number 12: 1Dd
###################################################

plot(test.o2,zvari=3,ylim=c(10,0),col=heat.colors(50),contour=FALSE)



###################################################
### chunk number 13: 1dother
###################################################
x <- test.o2$time
y <- test.o2$depth
z <- test.o2$data$TRACERSED

persp(x,y,z,theta=130,phi=30,xlab="Time",ylab="Space",zlab="Tracersed",
      shade=0.7,main="Model output",,col="lightblue",
      border="darkgray")




###################################################
### chunk number 14: sns
###################################################
sensible <- read.sns("BAY2.SNS")
plot(sensible)



###################################################
### chunk number 15: sns2
###################################################

plot(sensible,yvari=6)



###################################################
### chunk number 16: montecarlo
###################################################
feb.crl <- read.crl("FEBRUARI.CRL")
plot(feb.crl,xvari=3:5,yvari=25:28,size=0.6)



###################################################
### chunk number 17: 
###################################################
deepradon <- read.pcv("DEEPCOLLIN.PCV")




###################################################
### chunk number 18: 
###################################################
summary(deepradon)



###################################################
### chunk number 19: 
###################################################
summary(deepradon)[,1:2]



###################################################
### chunk number 20: 
###################################################
library(xtable)



###################################################
### chunk number 21: 
###################################################
xtable(summary(deepradon),digits=rep(4,6))



###################################################
### chunk number 22: 
###################################################
plot(deepradon)
  


###################################################
### chunk number 23: 
###################################################

plot(deepradon,pari=c(1,3))



###################################################
### chunk number 24: 
###################################################

plot(deepradon,scale=TRUE)



###################################################
### chunk number 25: 
###################################################
deepradon.parnames <- c(expression(epsilon),
                        expression(phi[s]),
                        expression(phi[infinity]),
                        expression(k[phi]),
                        expression(L),
                        expression(alpha),
                        expression(k[alpha~epsilon]),
                        )

plot(deepradon,parnames=deepradon.parnames)




###################################################
### chunk number 26: 
###################################################
deepradon.parnames.tex <- c("$\\epsilon$",
                        "$\\phi_s$",
                        "$\\phi_\\infty$",
                        "$k_\\phi$",
                        "$L$",
                        "$\\alpha$",
                        "$k_{\\alpha,\\epsilon}$",
                        )
xtable(summary(deepradon,parnames=deepradon.parnames.tex),digits=rep(4,6))




###################################################
### chunk number 27: read.bay
###################################################

berg <- read.bay("BERG_END.BAY")
summary(berg$data)



###################################################
### chunk number 28: plotbay
###################################################
plot(berg)



###################################################
### chunk number 29: pairsbay
###################################################
pairs(berg)



###################################################
### chunk number 30: raftery
###################################################
raftery.diag(berg$data,r=0.0125)



###################################################
### chunk number 31: newjump
###################################################

par1 <- lm(berg$data[,1]~berg$data[,-1])
summary(par1)$sigma

par2 <- lm(berg$data[,2]~berg$data[,-2])
summary(par2)$sigma




###################################################
### chunk number 32: inverse
###################################################
donali <- read.web("DONALI.WEB")
plot(donali,sizelab=1)



###################################################
### chunk number 33: inverseranges
###################################################
dotchart.web(donali,xlab=expression(gC~m^{-2}~yr^{-1}))



###################################################
### chunk number 34: readepar
###################################################
august <- read.par("august.par")
august

august$DeepPorosity

august[[2]] <- 5.0

write.par(august,file="")
write.par(august,file="test.par",ask=FALSE)



###################################################
### chunk number 35: createvector
###################################################

n=c(1,5,7)
n



###################################################
### chunk number 36: 
###################################################
x=1:10
x
y=seq(0,1,length=11)
y
F=rep("A",2)
F



###################################################
### chunk number 37: 
###################################################
G=rep(c("A","B"),3)
G



###################################################
### chunk number 38: 
###################################################
z=0:-20
nh4=600-(600-5)*exp(-0.2*-z)
par(mar=c(5.1,4.1,4.1,2.1))
heffa1=rnorm(10,mean=10)
heffa2=rnorm(10,mean=2)
heffa=c(heffa1,heffa2)
f1=rep("A",10)
f2=rep("B",10)
f=factor(c(f1,f2))



###################################################
### chunk number 39: subplot
###################################################
par(mfrow=c(1,2))
plot(nh4,z,type='b')
boxplot(heffa~f)




###################################################
### chunk number 40: math1
###################################################
x <- seq(0,10,length=100)
y <- 20/x+x^2
curve(20/x+x^2,xlim=c(0,10))
title(main=expression(frac(20,x)+x^2))
text(5,100,expression(C[2]*H[4]+3~O[2]%->%2~H[2]*O+2~CO[2]))



###################################################
### chunk number 41: margins
###################################################
plot(test,yvari=2,main="")
abline(v=12,lty=2,col=2)
text(15.1,0.1,"Mixed layer depth",adj=0)
arrows(15,0.1,12,0.12,lwd=2)




###################################################
### chunk number 42: 
###################################################
par(mfrow=c(2,2))
barplot(rep(c(1,2),5),col=rainbow(2))
barplot(rnorm(5),col=heat.colors(5))
barplot(1:10,col=rainbow(10))
pie(1:10,col=terrain.colors(10))



