% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schedule.R
\name{tidy_matchups}
\alias{tidy_matchups}
\title{Fantasy match schedule}
\usage{
tidy_matchups(leagueId = ffl_id(), leagueHistory = FALSE, ...)
}
\arguments{
\item{leagueId}{Numeric league ID or ESPN fantasy page URL. Defaults to
\code{getOption("fflr.leagueId")}. Function fails if no ID is found.}

\item{leagueHistory}{logical; Should the \code{leagueHistory} version of the API
be called? If \code{TRUE}, a list of results is returned, with one element for
each historical year of the league.}

\item{...}{Additional queries passed to \code{\link[httr:GET]{httr::GET()}}
(e.g., \code{scoringPeriodId}). Arguments are converted to a named list to be
passed alongside \code{view}.}
}
\value{
A data frame(s) of match opponents.
}
\description{
The opponents each team faces every week in a fantasy regular season.
Returned in a tidy format where each row is a single team with an indication
of home-away status. There are two rows per matchup, one for each team.
}
\examples{
tidy_matchups(leagueId = "42654852")
tidy_matchups(leagueId = "252353", leagueHistory = TRUE)
}
