% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flea_connect.R
\name{fleaflicker_connect}
\alias{fleaflicker_connect}
\title{Connect to Fleaflicker League}
\usage{
fleaflicker_connect(
  season = NULL,
  league_id = NULL,
  user_email = NULL,
  user_agent = NULL,
  rate_limit = TRUE,
  rate_limit_number = NULL,
  rate_limit_seconds = NULL,
  ...
)
}
\arguments{
\item{season}{Season to access on Fleaflicker - if missing, will guess based on system date (current year if March or later, otherwise previous year)}

\item{league_id}{League ID}

\item{user_email}{Optional - attempts to get user's user ID by email}

\item{user_agent}{User agent to self-identify (optional)}

\item{rate_limit}{TRUE by default - turn off rate limiting with FALSE}

\item{rate_limit_number}{number of calls per \code{rate_limit_seconds}, suggested is under 1000 calls per 60 seconds}

\item{rate_limit_seconds}{number of seconds as denominator for rate_limit}

\item{...}{other arguments (for other methods, for R compat)}
}
\value{
a list that stores Fleaflicker connection objects
}
\description{
This function creates a connection object which stores parameters and a user ID if available.
}
