% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_generics.R
\name{ff_connect}
\alias{ff_connect}
\title{Connect to a League}
\usage{
ff_connect(platform = "mfl", league_id = NULL, ...)
}
\arguments{
\item{platform}{one of MFL or Sleeper (Fleaflicker, ESPN, Yahoo in approximate priority order going forward)}

\item{league_id}{league_id (currently assuming one league at a time)}

\item{...}{other parameters passed to the connect function for each specific platform.}
}
\value{
a connection object to be used with \verb{ff_*} functions
}
\description{
This function creates a connection object which stores parameters and gets a login-cookie if available - it does so by passing arguments to the appropriate league-based handler.
}
\examples{
\donttest{
  ff_connect(platform = "mfl", season = 2019, league_id = 54040, rate_limit = FALSE)
}
}
\seealso{
\code{\link[=mfl_connect]{mfl_connect()}}, \code{\link[=sleeper_connect]{sleeper_connect()}}, \code{\link[=fleaflicker_connect]{fleaflicker_connect()}}, \code{\link[=espn_connect]{espn_connect()}}
}
