% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_generics.R, R/espn_transactions.R,
%   R/flea_transactions.R, R/mfl_transactions.R, R/sleeper_transactions.R
\name{ff_transactions}
\alias{ff_transactions}
\alias{ff_transactions.espn_conn}
\alias{ff_transactions.flea_conn}
\alias{ff_transactions.mfl_conn}
\alias{ff_transactions.sleeper_conn}
\title{Get League Transactions}
\usage{
ff_transactions(conn, ...)

\method{ff_transactions}{espn_conn}(conn, limit = 1000, ...)

\method{ff_transactions}{flea_conn}(conn, franchise_id = NULL, ...)

\method{ff_transactions}{mfl_conn}(conn, custom_players = deprecated(), ...)

\method{ff_transactions}{sleeper_conn}(conn, week = 1:17, ...)
}
\arguments{
\item{conn}{the list object created by \code{ff_connect()}}

\item{...}{additional args for other methods}

\item{limit}{number of most recent transactions to return}

\item{franchise_id}{fleaflicker returns transactions grouped by franchise id, pass a list here to filter}

\item{custom_players}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} - now returns custom players by default}

\item{week}{A week filter for transactions - 1 returns all offseason transactions. Default 1:17 returns all transactions.}
}
\value{
A tidy dataframe of transaction data
}
\description{
This function returns a tidy dataframe of transactions - generally one row per player per transaction per team.
Each trade is represented twice, once per each team.
}
\section{Methods (by class)}{
\itemize{
\item \code{espn_conn}: ESPN: returns adds, drops, and trades. Requires private/auth-cookie.

\item \code{flea_conn}: Fleaflicker: returns all transactions, including free agents, waivers, and trades.

\item \code{mfl_conn}: MFL: returns all transactions, including auction, free agents, IR, TS, waivers, and trades.

\item \code{sleeper_conn}: Sleeper: returns all transactions, including free agents, waivers, and trades.
}}

\examples{
\dontrun{
# Marked as don't run because this endpoint requires private authentication

conn <- espn_connect(
  season = 2020,
  league_id = 1178049,
  swid = Sys.getenv("TAN_SWID"),
  espn_s2 = Sys.getenv("TAN_ESPN_S2")
)
ff_transactions(conn)
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  conn <- fleaflicker_connect(season = 2020, league_id = 312861)
  ff_transactions(conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  dlf_conn <- mfl_connect(2019, league_id = 37920)
  ff_transactions(dlf_conn)
}) # end try
}
\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  jml_conn <- ff_connect(platform = "sleeper", league_id = "522458773317046272", season = 2020)
  ff_transactions(jml_conn, week = 1:2)
}) # end try
}

}
