% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorMessage.R
\name{getInBoundsErrorMessage}
\alias{getInBoundsErrorMessage}
\title{Create the error message for a certain parameter outside its bounds}
\usage{
getInBoundsErrorMessage(paramName, value = NULL, lowerBound, upperBound,
  algoName = NULL, strictly = FALSE, functionName = "")
}
\arguments{
\item{paramName}{Name of parameter, e.g. \code{lambda}}

\item{value}{The value of the non-finite parameter}

\item{lowerBound}{Lower bound of range, e.g. \code{0}.}

\item{upperBound}{Upper bound of range, e.g. \code{1}.}

\item{algoName}{Name of algorithm, e.g. \code{AFF change detector}}

\item{strictly}{Use "[" or "(" \code{strictly=FALSE} means "[" and
\code{strictly=TRUE} means "("}

\item{functionName}{The name of the original function which is being
called to check the parameters. Will help user
with debugging. Default is \code{""}, in which
case no function name will be displayed.}
}
\description{
For a particular parameter, create an error message specifying that
the parameter is outside its bounds.
}
\keyword{internal}

