% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processVectorsR.R
\name{computeAFFMean}
\alias{computeAFFMean}
\title{Quick computation of AFF mean of a given vector}
\usage{
computeAFFMean(x = c(0), eta = 0.01)
}
\arguments{
\item{x}{Vector of numeric values values. Default is \code{c(0)}, 
a vector of one element (zero)}

\item{eta}{Value for the step size in the gradient descent step. 
Default is \code{eta=0.01}.}
}
\value{
The adaptive forgetting factor mean (scalar).
}
\description{
Given a vector \code{x} and a value \code{eta} for step-size
in the stochastic gradient descent for the adaptive forgetting
factor, this returns the value of the fixed forgetting factor mean
\eqn{\bar{x}_{N, \overrightarrow{\lambda} }}, where \eqn{N} is the 
length of \code{x}. Algorithm is implemented in 'C++'.
}
\section{Author}{

Dean Bodenham
}

\section{References}{

D. A. Bodenham and N. M. Adams (2016) 
\emph{Continuous monitoring for changepoints in data 
streams using adaptive estimation}. 
Statistics and Computing  
doi:10.1007/s11222-016-9684-8
}

\seealso{
\code{\link{computeFFFMean}}
}
