% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sanitize.R
\name{sanitize_vft}
\alias{sanitize_vft}
\alias{sanitize_taxa}
\title{Fix common problems in \emph{ViewFullTable} and \emph{ViewTaxonomy} data.}
\usage{
sanitize_vft(.data, na = c("", "NA", "NULL"), ...)

sanitize_taxa(.data, na = c("", "NA", "NULL"), ...)
}
\arguments{
\item{.data}{A dataframe; either a ForestGEO \emph{ViewFullTable}
(\code{sanitize_vft()}).
or \emph{ViewTaxonomy} (\code{sanitize_vft()}).}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{...}{Arguments passed to \code{\link[readr:type_convert]{readr::type_convert()}}.}
}
\value{
A dataframe.
}
\description{
These functions fix common problems of \emph{ViewFullTable} and \emph{ViewTaxonomy}
data:
\itemize{
\item Ensure that each column has the correct type.
\item Ensure that missing values are represented with \code{NA}s -- not with the
literal string "NULL".
}
}
\section{Acknowledgments}{

Thanks to Shameema Jafferjee Esufali for motivating this functions.
}

\examples{
assert_is_installed("fgeo.x")

vft <- fgeo.x::vft_4quad

# Introduce problems to show how to fix them
# Bad column types
vft[] <- lapply(vft, as.character)
# Bad representation of missing values
vft$PlotName <- "NULL"

# "NULL" should be replaced by `NA` and `DBH` should be numeric
str(vft[c("PlotName", "DBH")])

# Fix
vft_sane <- sanitize_vft(vft)
str(vft_sane[c("PlotName", "DBH")])

taxa <- read.csv(fgeo.x::example_path("taxa.csv"))
# E.g. inserting bad column types
taxa[] <- lapply(taxa, as.character)
# E.g. inserting bad representation of missing values
taxa$SubspeciesID <- "NULL"

# "NULL" should be replaced by `NA` and `ViewID` should be integer
str(taxa[c("SubspeciesID", "ViewID")])

# Fix
taxa_sane <- sanitize_taxa(taxa)
str(taxa_sane[c("SubspeciesID", "ViewID")])
}
\seealso{
\code{\link[=read_vft]{read_vft()}}.
}
\concept{functions to edit ForestGEO data in place}
