% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_norway_map.R
\docType{data}
\name{norway_map_municips}
\alias{norway_map_municips}
\title{Maps of Norwegian Municipalities}
\format{\describe{
\item{long}{Location code.}
\item{lat}{Location name.}
\item{order}{The order that this line should be plotted in.}
\item{hole}{Geodata. Not used.}
\item{piece}{Geodata. Not used.}
\item{group}{Needs to be used as 'group' aesthetic in ggplot2.}
\item{id}{Non-informative id code.}
\item{location_code}{Location code (municipality code).}
}}
\source{
\url{https://kartkatalog.geonorge.no/metadata/uuid/cb02ab77-d3e6-4500-8a92-ea67367e7734}
}
\usage{
norway_map_municips
}
\description{
We conveniently package map datasets for Norwegian municipalities
(taken from Geonorge) that can be used in ggplot2 without needing any geo
libraries. This data is licensed under Creative Commons 0.
}
\examples{
library(ggplot2)
q <- ggplot(mapping = aes(x = long, y = lat, group = group))
q <- q + geom_polygon(data = fhidata::norway_map_municips, color = "black")
q <- q + theme_void()
q <- q + coord_quickmap()
q
}
\keyword{datasets}
