% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhircrack.R
\name{fhir_search}
\alias{fhir_search}
\title{Download Fhir search result}
\usage{
fhir_search(
  request,
  username = NULL,
  password = NULL,
  max_bundles = Inf,
  verbose = 1,
  max_attempts = 5,
  delay_between_attempts = 10,
  log_errors = 0
)
}
\arguments{
\item{request}{A string containing the full FHIR search request.}

\item{username}{A string containing the username for basic authentication. Defaults to NULL, meaning no authentication.}

\item{password}{A string containing the password for basic authentication. Defaults to NULL, meaning no authentication.}

\item{max_bundles}{Maximal number of bundles to get. Defaults to Inf meaning all available bundles are downloaded.}

\item{verbose}{An Integer Scalar.  If 0, nothings is printed, if 1, only finishing message is printed, if > 1,
downloading progress will be printed. Defaults to 2.}

\item{max_attempts}{A numeric scalar. The maximal number of attempts to send a request, defaults to 5.}

\item{delay_between_attempts}{A numeric scalar specifying the delay in seconds between two attempts. Defaults to 10.}

\item{log_errors}{Takes values 0, 1 or 2. Controls the logging of errors. 1 and 2 will write a file to the current working directory.

0: no logging of errors,

1: tabulate http response and write to csv-file

2: write http response as to xml-file}
}
\value{
A list of bundles in xml format.
}
\description{
Downloads all FHIR bundles of a FHIR search request from a FHIR server.
}
\examples{
\donttest{bundles <- fhir_search("https://hapi.fhir.org/baseR4/Medication?", max_bundles=3)}
}
