% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpa2meco.R
\name{mpa2meco}
\alias{mpa2meco}
\title{Transform metagenomic classification results of 'mpa' format to 'microtable' object.}
\usage{
mpa2meco(abund_table, sample_data = NULL, match_table = NULL, ...)
}
\arguments{
\item{abund_table}{'mpa' format abundance table, see the example.}

\item{sample_data}{default NULL; the sample metadata table, must be tab or comma seperated file, generally, a file with suffix "tsv" or "csv"..}

\item{match_table}{default NULL; a two column table used to replace the sample names in 'HUMAnN abundance result; Remember just two columns with no column names;
The first column must be sample names used in abund_table, the second column is the new sample names, e.g. the rownames in sample_table. See the example files.}

\item{...}{parameter passed to microtable$new function of microeco package, such as auto_tidy parameter.}
}
\value{
microtable object.
}
\description{
Transform the classification results of mpa (MetaPhlAn) format to microtable object,
such as MetaPhlAn and Kraken2 results. Kraken2 results can be obtained by merge_metaphlan_tables.py from MetaPhlAn or 
combine_mpa.py from KrakenTools (https://ccb.jhu.edu/software/krakentools/).
}
\examples{
\donttest{
# use the raw data files stored inside the package
abund_file_path <- system.file("extdata", "example_kraken2_merge.txt", package="file2meco")
sample_file_path <- system.file("extdata", "example_metagenome_sample_info.tsv", 
  package="file2meco")
match_file_path <- system.file("extdata", "example_metagenome_match_table.tsv", package="file2meco")
library(microeco)
library(file2meco)
library(magrittr)
mpa2meco(abund_table = abund_file_path)
test <- mpa2meco(abund_table = abund_file_path, sample_data = sample_file_path, 
  match_table = match_file_path)
# make the taxonomy standard for the following analysis
test$tax_table \%<>\% tidy_taxonomy
test$tidy_dataset()
}
}
