% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{receivers}
\alias{receivers}
\title{Receiver Data}
\format{
\subsection{\code{receivers}}{

A data frame with 52 rows and 10 columns:
\describe{
\item{dep_id}{A unique id is created for each receiver deployment}
\item{receiver_make}{The brand of the acoustic receiver}
\item{receiver_serial_number}{The serial number of the acoustic receiver}
\item{latitude}{The decimal degree latitude (WGS1984) of the acoustic
receiver at deployment}
\item{longitude}{The decimal degree longitude (WGS1984) of the acoustic
receiver at deployment}
\item{receiver_location}{The site name of an individual receiver, often
more than one \code{receiver_location} is found at a \code{receiver_general_location}}
\item{receiver_general_location}{The more general geographic name of the
location of the receiver}
\item{receiver_river_km}{The number of river kilometers the receiver is
from the Golden Gate Bridge}
\item{receiver_start}{The start time of the reciever (generally when it
was deployed)}
\item{receiver_end}{The end time of the receiver (generally when it was
retrieved)}
}
}
}
\source{
\url{https://oceanview.pfeg.noaa.gov/CalFishTrack/pageRealtime_download.html}
}
\usage{
receivers
}
\description{
An example dataset of real acoustic telemetry receivers within the California
Central Valley in 2021. These receivers are only those which match the
serial numbers in companion dataset \code{filtered_detections}. This data is
formatted to match the California Fish Tracking receiver metadata found here:
https://oceanview.pfeg.noaa.gov/CalFishTrack/.
}
\keyword{datasets}
