% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmultiboot.R
\name{glmmulti_boot}
\alias{glmmulti_boot}
\title{Binomial logistic regression multivariable models with bootstrapped
confidence intervals: \code{finalfit} model wrapper}
\usage{
glmmulti_boot(.data, dependent, explanatory, R = 1000)
}
\arguments{
\item{.data}{Dataframe.}

\item{dependent}{Character vector length 1:  name of depdendent variable
(must have 2 levels).}

\item{explanatory}{Character vector of any length: name(s) of explanatory
variables.}

\item{R}{Number of draws.}
}
\value{
A multivariable \code{\link[stats]{glm}} fitted model with
  bootstrapped confidence intervals. Output is of class \code{glmboot}.
}
\description{
Using \code{finalfit} conventions, produces a multivariable binomial logistic
regression models for a set of explanatory variables against a binary
dependent.
}
\details{
Uses \code{\link[stats]{glm}} with \code{finalfit} modelling conventions.
\code{boot::\link[boot]{boot}} is used to draw bootstrapped confidence
intervals on fixed effect model coefficients. Output can be passed to
\code{\link{fit2df}}.
}
\examples{
library(finalfit)
library(dplyr)
## Note number of draws set to 100 just for speed in this example
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "mort_5yr"

colon_s \%>\%
  glmmulti_boot(dependent, explanatory, R=100) \%>\%
  fit2df(estimate_suffix="(multivariable (BS CIs))")

}
\seealso{
\code{\link{fit2df}, \link{finalfit_merge}}

Other \code{finalfit} model wrappers: \code{\link{coxphmulti}},
  \code{\link{coxphuni}}, \code{\link{glmmixed}},
  \code{\link{glmmulti}}, \code{\link{glmuni}},
  \code{\link{lmmixed}}, \code{\link{lmmulti}},
  \code{\link{lmuni}}
}
