% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{finite_moment_test}
\alias{finite_moment_test}
\title{Finite Moment Test}
\usage{
finite_moment_test(
  obs,
  k,
  r = 0L,
  psi = 2,
  u = 1,
  force_random_variate_sample = 0L,
  ignore_errors = 0L,
  verbose = 0L,
  random_salting = 0L
)
}
\arguments{
\item{obs}{Observations (type: armadillo numeric vector).}

\item{k}{Moment order (type: double)}

\item{r}{Artificial sample size (type: int). Default is N^0.8.}

\item{psi}{Pescaling moment (type: double). Must be <k. Default is 2.0.}

\item{u}{Sampling range width for sampling range [-u, u] (type: double) Default is 1.0.}

\item{force_random_variate_sample}{If True, draw random variates for xi and u_series. If False, use quantile function values from a regular percentile space grid. This represents the density function better. Defaiult is False.}

\item{ignore_errors}{Ignore errors caused by Inf and NaN results for too large absolute moments. If True, it will return test statistic=NA, pvalue=1. If False, it will stop with an error. Default is False. But normally this will indicate an infinite moment.}

\item{verbose}{If True, print detailed output for debugging. Default is False.}

\item{random_salting}{Salt number to be added to the random seed (type: int). This prevents identical random variate series if multiple instances are started and run in parallel. Default is 0.}
}
\value{
Trapani's Theta test statistic (type: double).

Corresponding p-value (Chi^2(1) percentile) (type: double).
}
\description{
Computes Trapani's (2016) finite moment test for moment of order k of the distribution of a given the sample of observations obs. Knowledge of the identity of the distribution is not required. The null hypothesis is that the moment is infinite; the alternative is that it is finite. The function takes parameters of the test as optional arguments; some insights into the impact the choice of parameter values has are given in Trapani (2016).
}
\examples{
library(stabledist)
rvs <- rstable(100000, 1.9, 0.5, 1, 0, pm = 0)
result <- finite_moment_test(rvs, 2)
}
