% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{activated_FCRN}
\alias{activated_FCRN}
\title{Activated frequency containment reserve for normal operation}
\usage{
activated_FCRN(start_time = NA, end_time = NA, user_key = NA)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains activated Frequency Containment
Reserve for Normal operation (FCR-N) is published hourly one hour after
the hour in question, for example the value for hour 07-08 is published
at 9 o'clock.
}
\description{
Check https://data.fingrid.fi/en/dataset/activated-frequency-containment-reserve-for-normal-operation
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- activated_FCRN(
    start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
