% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_prepare_conll-u.R
\name{fst_prepare_conllu}
\alias{fst_prepare_conllu}
\title{Read In and format Finnish survey text responses}
\usage{
fst_prepare_conllu(data, field, model = "ftb", stopword_list = "nltk")
}
\arguments{
\item{data}{A dataframe of survey responses which contains an open-ended
question.}

\item{field}{The field in the dataframe which contains the open-ended
question.}

\item{model}{A Finnish language model available for [udpipe], `"ftb"`
(default) or `"tdt"`.}

\item{stopword_list}{A valid Finnish stopword list, default is `"nltk"`, or
`"none"`.}
}
\value{
A dataframe of Finnish text in CoNLL-U format.
}
\description{
`fst_prepare_conllu()` produces a dataframe (and saves as csv) containing
Finnish survey text reponses in CoNLL-U format with stopwords removed.
}
\examples{
\donttest{
cb <- child_barometer_data
fst_prepare_conllu(data = cb, field = "q7", stopword_list = "stopwords-iso")
unlink("finnish-ftb-ud-2.5-191206.udpipe")
unlink("finnish-tdt-ud-2.5-191206.udpipe")
}
}
