% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnp_model_mcmc.R
\name{cnp_mcmc}
\alias{cnp_mcmc}
\title{cnp_mcmc}
\usage{
cnp_mcmc(TL, param, iter, params_st, cor, ...)
}
\arguments{
\item{TL}{Total length(s) in cm}

\item{param}{List of all parameter means (add "_m") and standard deviations (add "_sd") Default parameters are set with very low sd's.
parameters:
\itemize{
\item{Qc_m, Qc_sd:} percentage C of dry mass fish
\item{Qn_m, Qn_sd:} percentage N of dry mass fish
\item{Qp_m, Qp_sd:} percentage P of dry mass fish
\item{Dc_m, Dc_sd:} percentage C of dry mass food
\item{Dn_m, Dn_sd:} percentage N of dry mass food
\item{Dp_m, Dp_sd:} percentage P of dry mass food
\item{ac_m, ac_sd:} C-specific assimilation efficiency
\item{an_m, an_sd:} N-specific assimilation efficiency
\item{ap_m, ap_sd:} P-specific assimilation efficiency
\item{linf_m, linf_sd:} Von Bertalanffy Growth parameter, theoretical maximum size in TL (cm)
\item{k_m, k_sd:} Von Bertalanffy Growth parameter, growth rate (yr^-1)
\item{t0_m, tO_sd:} Von Bertalanffy Growth parameter (yr)
\item{lwa_m, lwa_sd:} Parameter length-weight relationship (g cm^-1)
\item{lwb_m, lwb_sd:} Parameter length-weight relationship
\item{mdw_m, wprop_sd:} Ratio between dry weight and wet weight of fish
\item{F0nz_m, F0nz_sd:} N-specific turnover rate
\item{F0pz_m, F0pz_sd:} P-specific turnover rate
\item{f0_m, f0_sd:} Metabolic normalisation constant independent of body mass (g C g^-alpha d^-1)
\item{alpha_m, alpha_sd:} Metabolic rate mass-scaling exponent
\item{theta_m, theta_sd:} Activity scope
\item{r_m, r_sd:} Aspect ratio of caudal fin
\item{h_m, h_sd:} Trophic level
\item{v_m, v_sd:} Environmental temperature (degrees celcius)
}}

\item{iter}{A positive integer specifying the number of iterations. The default is 2000.}

\item{params_st}{Standard parameters.}

\item{cor}{A list of correlations between certain parameters: ro_Qc_Qn, ro_Qc_Qp, ro_Qn_Qp,
ro_Dc_Dn, ro_Dc_Dp, ro_Dn_Dp, ro_lwa_lwb, ro_alpha_f0}

\item{...}{Additional arguments rstan::sampling, see ?rstan:sampling}
}
\description{
cnp_mcmc
}
