% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cnp.R
\name{plot_cnp}
\alias{plot_cnp}
\title{A function to plot results model}
\usage{
plot_cnp(mod, y, x = "tl", probs = c(0.8, 0.95))
}
\arguments{
\item{mod}{Model output from cnp_model_mcmc()}

\item{y}{Output variable(s) to be plotted. Can be a character or a character vector.}

\item{x}{Variable to be put on x-axis, "biomass" or "tl"}

\item{probs}{Width of the confidence}
}
\description{
This function allows you to plot an overview of the model results in function of the total length of fish
}
\examples{
library(fishflux)
mod <- cnp_model_mcmc(TL = 5:15, param = list(
          Qc_m = 40, Qn_m = 10, Qp_m = 4, Dn_sd = 0.05))
plot_cnp(mod = mod, y = c("Fp", "Gp", "Wp", "Ip"),
         x = "tl", probs = c(0.5, 0.8))
plot_cnp(mod = mod, y = "Fp", x = "tl",
         probs = c(0.5, 0.8, 0.95))

}
\keyword{bioenergetic}
\keyword{fish}
\keyword{model}
\keyword{plot}
\keyword{stoichiometry}
