% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract}
\alias{extract}
\title{A function to extract specific model output parameters from result}
\usage{
extract(mod, par)
}
\arguments{
\item{mod}{Output from cnp_mod_mcmc()}

\item{par}{Character vector specifying which output parameter that should be returned.}
}
\value{
Main model output parameters:
\itemize{
\item{F0c:} C-specific minimal inorganic flux (g/day)
\item{F0n:} N-specific minimal inorganic flux (g/day)
\item{F0p:} P-specific minimal inorganic flux (g/day)
\item{Gc:} Carbon-specific growth rate (g/day)
\item{Gn:} Nitrogen-specific growth rate (g/day)
\item{Gp:} Phosphorus-specific growth rate (g/day)
\item{Sc:} C-specific minimal supply rate (g/day)
\item{Sn:} N-specific minimal supply rate (g/day)
\item{Sp:} P-specific minimal supply rate (g/day)
\item{Ic:} Ingestion rate of C (g/day)
\item{In:} Ingestion rate of N (g/day)
\item{Ip:} Ingestion rate of P (g/day)
\item{Wc:} Egestion rate of C (g/day)
\item{Wn:} Egestion rate of N (g/day)
\item{Wp:} Egestion rate of P (g/day)
\item{Fc:} Total inorganic flux of C (respiration) (g/day)
\item{Fn:} Total inorganic flux of N (excretion) (g/day)
\item{Fp:} Total inorganic flux of P (excretion) (g/day)
}
}
\description{
A function to extract specific model output parameters from result
}
\details{
Returns a data.frame with a summary of the selected output parameters
}
\examples{
model <- cnp_model_mcmc(TL = 5:10, param = list(Qc_m = 40, Qn_m = 10, Qp_m = 4))
extract(model, c("Fn","Fp"))

}
\keyword{excretion}
\keyword{fish}
\keyword{mcmc}
\keyword{stoichiometry}
