######################################################################
#' First derivative of the density
#' Created by Stephen Jewson
#' using Deriv() by Andrew Clausen and Serguei Sokol
#' @returns Vector
#' @inheritParams manf
gev_p123_fd=function (x, t1, t2, t3, v1, v2, v3, v4, v5, v6) 
{
    .e2 <- t3 * v6 + v5
    .e4 <- exp(-(t2 * v4 + v3))
    .e7 <- x - (t1 * v2 + v1)
    .e8 <- 1/.e2
    .e10 <- .e4 * .e2 * .e7
    .e11 <- 1 + .e10
    .e12 <- 1 + .e8
    .e13 <- .e11^.e12
    .e15 <- .e11^(.e8 + 2)
    .e16 <- exp(-.e11^-.e8)
    .e19 <- .e12 * .e2/.e15 - 1/.e11^(2 * .e12)
    .e23 <- .e19 * .e4 * .e7 - 1/.e13
    .e31 <- (log1p(.e10)/(.e13 * .e2) - (log1p(.e10)/(.e11^.e8 * 
        .e2) - .e4 * .e7/.e13)/.e13)/.e2 - .e12 * .e4 * .e7/.e15
    .e32 <- .e4^2
    c(v1 = .e19 * .e16 * .e32, v2 = t1 * .e19 * .e16 * .e32, 
        v3 = .e23 * .e16 * .e4, v4 = t2 * .e23 * .e16 * .e4, 
        v5 = .e31 * .e16 * .e4, v6 = t3 * .e31 * .e16 * .e4)
}
######################################################################
#' Second derivative of the density
#' Created by Stephen Jewson
#' using Deriv() by Andrew Clausen and Serguei Sokol
#' @returns Matrix
#' @inheritParams manf
gev_p123_fdd=function (x, t1, t2, t3, v1, v2, v3, v4, v5, v6) 
{
    .e2 <- t3 * v6 + v5
    .e4 <- exp(-(t2 * v4 + v3))
    .e7 <- x - (t1 * v2 + v1)
    .e8 <- 1/.e2
    .e10 <- .e4 * .e2 * .e7
    .e11 <- 1 + .e10
    .e12 <- 1 + .e8
    .e13 <- .e11^.e12
    .e14 <- .e8 + 2
    .e15 <- log1p(.e10)
    .e16 <- 2 * .e12
    .e17 <- .e11^.e14
    .e18 <- .e11^.e8
    .e19 <- .e11^.e16
    .e20 <- .e18 * .e2
    .e21 <- .e4 * .e7
    .e22 <- .e2^2
    .e23 <- 1/.e19
    .e26 <- .e15/.e20 - .e21/.e13
    .e28 <- .e13 * .e2
    .e29 <- 2 * .e14
    .e30 <- exp(-.e11^-.e8)
    .e31 <- 1/.e13
    .e32 <- 1/.e17
    .e35 <- .e12 * .e2/.e17 - .e23
    .e37 <- .e11^(.e12 - .e29) * .e14
    .e38 <- .e11^(.e8 - .e16)
    .e39 <- .e26/.e13
    .e40 <- .e15/.e28
    .e44 <- .e12 * .e18 * .e4 * .e7 - .e13 * .e15/.e22
    .e46 <- .e37 * .e2 - 2/.e11^(1 + .e16)
    .e47 <- (.e40 - .e39)/.e2
    .e48 <- .e4^2
    .e49 <- .e44/.e19
    .e52 <- .e35 * .e4 * .e7 - .e31
    .e53 <- (.e13 * .e14 * .e4 * .e7 - .e17 * .e15/.e22) * .e12
    .e54 <- .e28^2
    .e55 <- .e20^2
    .e58 <- .e12 * .e4 * .e7/.e17
    .e59 <- .e11^(.e8 - 1)
    .e60 <- .e18 * .e15
    .e61 <- .e11^.e29
    .e62 <- .e52/.e13
    .e65 <- ((.e60 * .e2/.e54 - .e38 * .e26) * .e12 * .e2 - (((.e59 * 
        .e15/.e55 - .e12 * .e38 * .e4 * .e7) * .e2 + .e31 - .e31)/.e13 + 
        .e32))/.e2
    .e69 <- .e46 * .e12 * .e2 - .e35/.e13
    .e71 <- .e46 * .e4 * .e7
    .e73 <- .e53 * .e2/.e61
    .e74 <- (.e47 - .e58)/.e13
    .e80 <- .e37 * .e4 * .e2 * .e7
    .e81 <- .e38 + .e32
    .e86 <- (2 * (.e12 * .e11^(.e16 - 1) * .e4 * .e7) - 2 * (.e19 * 
        .e15/.e22))/.e11^(4 * .e12) + .e32
    .e88 <- ((.e49 + .e58 - .e47) * .e26 + (.e39 + .e21/.e17 - 
        .e40)/.e2 - (((.e49 + 1/.e28) * .e4 * .e7 - (.e59 * .e4 * 
        .e7 + .e18 - .e60/.e2) * .e15/.e55)/.e13 + (.e44 * .e2 + 
        .e13) * .e15/.e54))/.e2 + (.e53/.e61 + 1/(.e17 * .e22)) * 
        .e4 * .e7
    .e91 <- ((.e71 - (.e81 + .e32)) * .e12 * .e2 + .e23 + .e23 - 
        .e62) * .e4 * .e7 + .e31
    .e94 <- (.e65 + .e12 * (2/.e17 - .e80) - .e74) * .e4 * .e7 - 
        .e47
    .e99 <- .e69 * .e4 * .e7 - 2 * .e35
    .e103 <- (.e71 - .e81) * .e12 * .e2 + .e23 - .e62
    .e104 <- .e65 - ((.e80 - .e32) * .e12 + .e74)
    .e106 <- .e49 + (.e86 - .e73) * .e4 * .e7 - .e52 * .e26/.e2
    .e110 <- .e86 - (.e35 * .e26/.e2 + .e73)
    .e111 <- .e4^3
    .e114 <- t1 * .e69 * .e30 * .e111
    .e115 <- t1 * t2
    .e116 <- t1 * t3
    .e119 <- t2 * .e91 * .e30 * .e4
    .e120 <- t2 * t3
    .e123 <- t3 * .e88 * .e30 * .e4
    c(v1 = c(v1 = .e69 * .e30 * .e111, v2 = .e114, v3 = .e103 * 
        .e30 * .e48, v4 = t2 * .e103 * .e30 * .e48, v5 = .e104 * 
        .e30 * .e48, v6 = t3 * .e104 * .e30 * .e48), v2 = c(v1 = .e114, 
        v2 = t1^2 * .e69 * .e30 * .e111, v3 = t1 * .e103 * .e30 * 
            .e48, v4 = .e115 * .e103 * .e30 * .e48, v5 = t1 * 
            .e104 * .e30 * .e48, v6 = .e116 * .e104 * .e30 * 
            .e48), v3 = c(v1 = .e99 * .e30 * .e48, v2 = t1 * 
        .e99 * .e30 * .e48, v3 = .e91 * .e30 * .e4, v4 = .e119, 
        v5 = .e94 * .e30 * .e4, v6 = t3 * .e94 * .e30 * .e4), 
        v4 = c(v1 = t2 * .e99 * .e30 * .e48, v2 = .e115 * .e99 * 
            .e30 * .e48, v3 = .e119, v4 = t2^2 * .e91 * .e30 * 
            .e4, v5 = t2 * .e94 * .e30 * .e4, v6 = .e120 * .e94 * 
            .e30 * .e4), v5 = c(v1 = .e110 * .e30 * .e48, v2 = t1 * 
            .e110 * .e30 * .e48, v3 = .e106 * .e30 * .e4, v4 = t2 * 
            .e106 * .e30 * .e4, v5 = .e88 * .e30 * .e4, v6 = .e123), 
        v6 = c(v1 = t3 * .e110 * .e30 * .e48, v2 = .e116 * .e110 * 
            .e30 * .e48, v3 = t3 * .e106 * .e30 * .e4, v4 = .e120 * 
            .e106 * .e30 * .e4, v5 = .e123, v6 = t3^2 * .e88 * 
            .e30 * .e4))
}
######################################################################
#' First derivative of the cdf
#' Created by Stephen Jewson
#' using Deriv() by Andrew Clausen and Serguei Sokol
#' @returns Vector
#' @inheritParams manf
gev_p123_pd=function (x, t1, t2, t3, v1, v2, v3, v4, v5, v6) 
{
    .e2 <- t3 * v6 + v5
    .e4 <- exp(-(t2 * v4 + v3))
    .e7 <- x - (t1 * v2 + v1)
    .e9 <- .e4 * .e2 * .e7
    .e10 <- 1 + .e9
    .e11 <- 1/.e2
    .e13 <- .e10^(1 + .e11)
    .e14 <- exp(-.e10^-.e11)
    .e17 <- .e14 * .e4
    .e22 <- log1p(.e9)/(.e10^.e11 * .e2) - .e4 * .e7/.e13
    c(v1 = -(.e17/.e13), v2 = -(t1 * .e14 * .e4/.e13), v3 = -(.e17 * 
        .e7/.e13), v4 = -(t2 * .e14 * .e4 * .e7/.e13), v5 = -(.e14 * 
        .e22/.e2), v6 = -(t3 * .e14 * .e22/.e2))
}
######################################################################
#' Second derivative of the cdf
#' Created by Stephen Jewson
#' using Deriv() by Andrew Clausen and Serguei Sokol
#' @returns Matrix
#' @inheritParams manf
gev_p123_pdd=function (x, t1, t2, t3, v1, v2, v3, v4, v5, v6) 
{
    .e2 <- t3 * v6 + v5
    .e4 <- exp(-(t2 * v4 + v3))
    .e7 <- x - (t1 * v2 + v1)
    .e8 <- 1/.e2
    .e10 <- .e4 * .e2 * .e7
    .e11 <- 1 + .e10
    .e12 <- 1 + .e8
    .e13 <- .e11^.e12
    .e14 <- .e11^.e8
    .e15 <- log1p(.e10)
    .e16 <- 2 * .e12
    .e18 <- .e14 * .e2
    .e19 <- exp(-.e11^-.e8)
    .e21 <- .e4 * .e7/.e13
    .e22 <- .e12 * .e11^(.e8 - .e16)
    .e23 <- .e15/.e18
    .e24 <- .e22 * .e4
    .e25 <- .e23 - .e21
    .e26 <- .e11^.e16
    .e27 <- 1/.e13
    .e28 <- (.e12 * .e14 * .e4 * .e7 - .e13 * .e15/.e2^2)/.e26
    .e29 <- .e18^2
    .e32 <- .e24 * .e2 * .e7 - (1 + .e21)/.e13
    .e33 <- .e13 * .e2
    .e34 <- .e11^(.e8 - 1)
    .e35 <- .e28 + .e25/.e33
    .e38 <- (.e34 * .e15/.e29 - .e24 * .e7) * .e2 + .e27 - (.e25/.e13 + 
        .e27)
    .e41 <- (.e28 + 1/.e33) * .e4 * .e7 - ((.e34 * .e4 * .e7 + 
        .e14 - .e14 * .e15/.e2) * .e15/.e29 + (1 + .e23 - .e21) * 
        .e25/.e2)
    .e43 <- .e22 * .e2 - 1/.e26
    .e44 <- .e4^2
    .e47 <- t2 * .e32 * .e19 * .e4
    .e49 <- .e32 * .e19 * .e4
    .e50 <- -.e49
    .e51 <- -(t1 * .e43 * .e19 * .e44)
    .e52 <- -(t1 * .e32 * .e19 * .e4)
    .e53 <- -(t1 * t2 * .e32 * .e19 * .e4)
    .e54 <- -(.e47 * .e7)
    .e55 <- -.e47
    .e56 <- -(t3 * .e41 * .e19/.e2)
    .e58 <- .e35 * .e19 * .e4
    .e60 <- .e38 * .e19 * .e4
    .e61 <- t1 * t3
    .e62 <- t2 * t3
    .e65 <- t3 * .e35 * .e19 * .e4
    .e68 <- t3 * .e38 * .e19 * .e4
    c(v1 = c(v1 = -(.e43 * .e19 * .e44), v2 = .e51, v3 = .e50, 
        v4 = .e55, v5 = -(.e60/.e2), v6 = -(.e68/.e2)), v2 = c(v1 = .e51, 
        v2 = -(t1^2 * .e43 * .e19 * .e44), v3 = .e52, v4 = .e53, 
        v5 = -(t1 * .e38 * .e19 * .e4/.e2), v6 = -(.e61 * .e38 * 
            .e19 * .e4/.e2)), v3 = c(v1 = .e50, v2 = .e52, v3 = -(.e49 * 
        .e7), v4 = .e54, v5 = -(.e60 * .e7/.e2), v6 = -(.e68 * 
        .e7/.e2)), v4 = c(v1 = .e55, v2 = .e53, v3 = .e54, v4 = -(t2^2 * 
        .e32 * .e19 * .e4 * .e7), v5 = -(t2 * .e38 * .e19 * .e4 * 
        .e7/.e2), v6 = -(.e62 * .e38 * .e19 * .e4 * .e7/.e2)), 
        v5 = c(v1 = .e58, v2 = t1 * .e35 * .e19 * .e4, v3 = .e58 * 
            .e7, v4 = t2 * .e35 * .e19 * .e4 * .e7, v5 = -(.e41 * 
            .e19/.e2), v6 = .e56), v6 = c(v1 = .e65, v2 = .e61 * 
            .e35 * .e19 * .e4, v3 = .e65 * .e7, v4 = .e62 * .e35 * 
            .e19 * .e4 * .e7, v5 = .e56, v6 = -(t3^2 * .e41 * 
            .e19/.e2)))
}
############################################################
#' Second derivative of the log density
#' Created by Stephen Jewson
#' using Deriv() by Andrew Clausen and Serguei Sokol
#' @returns Matrix
#' @inheritParams manf
gev_p123_logfdd=function (x, t1, t2, t3, v1, v2, v3, v4, v5, v6) 
{
    .e2 <- t3 * v6 + v5
    .e4 <- exp(-(t2 * v4 + v3))
    .e7 <- x - (t1 * v2 + v1)
    .e9 <- .e4 * .e2 * .e7
    .e10 <- 1 + .e9
    .e11 <- 1/.e2
    .e12 <- .e10^.e11
    .e13 <- 1 + .e11
    .e14 <- 1/.e12
    .e15 <- .e13 * .e2
    .e16 <- log1p(.e9)
    .e17 <- .e15 - .e14
    .e18 <- .e10^(.e11 - 1)
    .e20 <- .e17 * .e2 - .e14
    .e22 <- (.e20 * .e4 * .e7 + 1/.e18)/.e10 - .e15
    .e25 <- .e18 * .e4 * .e7 - .e12 * .e16/.e2
    .e27 <- .e10^(2/.e2 - 1) * .e2
    .e28 <- .e14 - 1
    .e29 <- 2 * .e13
    .e31 <- (.e25/.e27 - .e17 * .e4 * .e7)/.e10 + 1
    .e33 <- (((.e16/.e12 - .e28 * .e2)/.e2 + .e14)/.e10 - .e13 * 
        .e10^(.e11 - .e29) * .e4 * .e2 * .e7)/.e2 + .e13 * (.e9/.e10 - 
        1)/.e10
    .e34 <- .e2^2
    .e36 <- ((((2/.e12 - 1) * .e4 * .e7 - .e25 * .e16/.e27)/.e10 - 
        2 * (.e28 * .e16/.e2))/.e2 + (.e13 * .e12 * .e4 * .e7 - 
        .e10^.e13 * .e16/.e34) * .e4 * .e7/.e10^.e29)/.e2 - (.e13 * 
        .e4 * .e7/.e10 + 1/.e34) * .e4 * .e7/.e10
    .e37 <- .e10^2
    .e38 <- .e4^2
    .e40 <- t2 * .e22 * .e4
    .e41 <- .e22 * .e4
    .e42 <- -(t3 * .e36)
    .e43 <- .e41/.e10
    .e44 <- .e31 * .e4
    .e45 <- .e33 * .e4
    .e48 <- t1 * .e22 * .e4/.e10
    .e51 <- t1 * .e20 * .e38/.e37
    .e55 <- t1 * t2 * .e22 * .e4/.e10
    .e56 <- t1 * t3
    .e58 <- .e40 * .e7/.e10
    .e59 <- .e40/.e10
    .e60 <- t2 * t3
    .e62 <- t3 * .e31 * .e4
    .e64 <- t3 * .e33 * .e4
    c(v1 = c(v1 = .e20 * .e38/.e37, v2 = .e51, v3 = .e43, v4 = .e59, 
        v5 = -.e45, v6 = -.e64), v2 = c(v1 = .e51, v2 = t1^2 * 
        .e20 * .e38/.e37, v3 = .e48, v4 = .e55, v5 = -(t1 * .e33 * 
        .e4), v6 = -(.e56 * .e33 * .e4)), v3 = c(v1 = .e43, v2 = .e48, 
        v3 = .e41 * .e7/.e10, v4 = .e58, v5 = -(.e45 * .e7), 
        v6 = -(.e64 * .e7)), v4 = c(v1 = .e59, v2 = .e55, v3 = .e58, 
        v4 = t2^2 * .e22 * .e4 * .e7/.e10, v5 = -(t2 * .e33 * 
            .e4 * .e7), v6 = -(.e60 * .e33 * .e4 * .e7)), v5 = c(v1 = .e44/.e10, 
        v2 = t1 * .e31 * .e4/.e10, v3 = .e44 * .e7/.e10, v4 = t2 * 
            .e31 * .e4 * .e7/.e10, v5 = -.e36, v6 = .e42), v6 = c(v1 = .e62/.e10, 
        v2 = .e56 * .e31 * .e4/.e10, v3 = .e62 * .e7/.e10, v4 = .e60 * 
            .e31 * .e4 * .e7/.e10, v5 = .e42, v6 = -(t3^2 * .e36)))
}
############################################################
#' Third derivative of the log density
#' Created by Stephen Jewson
#' using Deriv() by Andrew Clausen and Serguei Sokol
#' @returns 3d array
#' @inheritParams manf
gev_p123_logfddd=function (x, t1, t2, t3, v1, v2, v3, v4, v5, v6) 
{
    .e2 <- t3 * v6 + v5
    .e4 <- exp(-(t2 * v4 + v3))
    .e7 <- x - (t1 * v2 + v1)
    .e9 <- .e4 * .e2 * .e7
    .e10 <- 1 + .e9
    .e11 <- 1/.e2
    .e12 <- .e10^.e11
    .e13 <- 1 + .e11
    .e14 <- .e11 - 1
    .e15 <- .e10^.e14
    .e16 <- log1p(.e9)
    .e17 <- 1/.e12
    .e18 <- 2/.e2
    .e19 <- .e18 - 1
    .e21 <- .e15 * .e4 * .e7
    .e23 <- .e12 * .e16/.e2
    .e24 <- .e21 - .e23
    .e25 <- .e10^.e19
    .e26 <- .e13 * .e2
    .e27 <- 2 * .e13
    .e28 <- .e10^.e13
    .e29 <- .e25 * .e2
    .e30 <- .e2^2
    .e31 <- 1/.e15
    .e32 <- .e26 - .e17
    .e33 <- .e11 - .e27
    .e34 <- .e17 - 1
    .e36 <- .e32 * .e2 - .e17
    .e37 <- .e10^(.e18 - 2)
    .e38 <- .e24/.e29
    .e39 <- .e10^.e33
    .e41 <- (.e16/.e12 - .e34 * .e2)/.e2
    .e43 <- .e36 * .e4 * .e7
    .e44 <- .e9/.e10
    .e45 <- .e41 + .e17
    .e46 <- .e15 * .e16
    .e49 <- .e10^(.e11 - 2) * .e14 * .e4
    .e50 <- .e10^.e18
    .e51 <- .e10^2
    .e52 <- .e2/.e28
    .e54 <- .e32 * .e4 * .e7
    .e55 <- 2/.e15
    .e56 <- .e29^2
    .e57 <- 2 * .e14
    .e58 <- .e44 - 1
    .e59 <- .e4 * .e7
    .e60 <- .e43 + .e31
    .e61 <- .e38 - .e54
    .e63 <- (.e52 + 1/.e28) * .e4 * .e7
    .e64 <- .e13 * .e39
    .e65 <- .e13 * .e12
    .e66 <- .e13 * .e58
    .e67 <- .e28 * .e16
    .e68 <- .e37 * .e2
    .e70 <- (.e15 * .e2 + .e46)/.e2 - (.e15 + .e49 * .e2 * .e7)
    .e72 <- .e24 * .e37 * .e19
    .e73 <- .e67/.e30
    .e76 <- .e10^(.e11 - (1 + .e27)) * .e33 * .e4
    .e78 <- .e10^(.e11 - (2 + .e57)) * .e14
    .e81 <- .e49 * .e7 - .e46/.e30
    .e82 <- .e31 + 2 * .e43
    .e83 <- 2 * .e26
    .e84 <- .e59/.e12
    .e85 <- .e4^2
    .e86 <- (.e45/.e10 - .e64 * .e4 * .e2 * .e7)/.e2
    .e88 <- .e24 * .e16/.e29
    .e90 <- .e65 * .e4 * .e7
    .e91 <- .e82 + .e55
    .e93 <- ((((.e60 + .e31 + .e31)/.e10 + .e78 - .e83) * .e2 + 
        .e17 + .e17 - .e63) * .e4 * .e7 - .e31)/.e10 + ((.e60/.e10 - 
        .e26) * .e4 * .e7/.e10 + 1 + .e11) * .e2
    .e95 <- (((.e45 * .e2 + .e17)/.e10 + (.e16/.e28 - 2 * .e52)/.e2)/.e10 + 
        (.e76 * .e2 * .e7 + .e39) * .e13 * .e2)/.e2 + 2 * (.e66 * 
        .e2/.e51)
    .e98 <- .e70/.e68 + .e61 * .e2 + .e84
    .e100 <- .e61/.e10 + .e72 * .e2/.e56
    .e101 <- .e24/.e50
    .e102 <- .e90 - .e73
    .e103 <- .e10^.e27
    .e105 <- (2/.e12 - 1) * .e4 * .e7
    .e108 <- (((.e98 - .e55)/.e10 + (.e100 + .e18 + 3) * .e2) * 
        .e4 * .e7 - .e38)/.e10 - 1
    .e110 <- ((((.e101 + 2)/.e2 + 3) * .e2 + (.e38 - .e91)/.e10) * 
        .e4 * .e7 - .e81/.e10^.e57)/.e10 - 1
    .e113 <- .e95 * .e4 * .e7 - (.e86 + .e66/.e10)
    .e117 <- .e81 * .e4 * .e7 - ((.e21 - (.e12 + .e23)) * .e16/.e2 + 
        .e21)/.e2
    .e119 <- (.e37 * .e19 * .e4 * .e7 - 2 * (.e25 * .e16/.e30)) * 
        .e2 + .e25
    .e123 <- .e13 * .e4 * .e7/.e10 + 1/.e30
    .e124 <- .e10^(.e27 - 1)
    .e125 <- .e50 * .e2
    .e126 <- .e105 - .e88
    .e127 <- 2 * .e44
    .e128 <- t1 * t2
    .e129 <- t1 * t3
    .e130 <- t2 * t3
    .e132 <- ((((.e65 * .e16 + .e12)/.e2 - (.e21 + .e12 + .e12) * 
        .e13) * .e4 * .e7 + .e73)/.e124 + ((.e126 * .e2 + 2 * 
        .e84 - ((.e70 * .e16 - .e24 * .e2/.e10)/.e68 + .e55))/.e10 + 
        2 - (.e72 * .e16 * .e30/.e56 + 2 * .e41))/.e2 + 2 * (.e102 * 
        .e13 * .e4 * .e2 * .e7/.e103))/.e2 - (.e123 * .e2 + .e13 * 
        (.e44 - 2)) * .e4 * .e7/.e10
    .e134 <- (((.e24 * (1/.e50 - (1/.e50 + .e16/.e125)) + 1 + 
        .e59/.e28 - .e45)/.e2 - .e45 * .e4 * .e7/.e10)/.e10 - 
        ((((.e76 * .e7 + .e39 * .e16/.e30) * .e13 - .e39/.e30) * 
            .e2 + .e64) * .e4 * .e7 + .e86))/.e2 + (.e13 * (2 - 
        .e127) * .e4 * .e7/.e10 - .e58/.e30)/.e10
    .e139 <- .e117/.e29 - (((.e24 * (1/.e25 + 2/.e25)/.e2 - 2 * 
        .e54)/.e10 + 2) * .e4 * .e7 + .e119 * .e24/.e56)
    .e142 <- (.e78 + .e91/.e10 - .e83) * .e2 + .e17 - .e63
    .e144 <- .e34 * .e16/.e2
    .e145 <- t1^2
    .e146 <- t2^2
    .e147 <- t3^2
    .e149 <- t2 * .e93 * .e4
    .e151 <- (((.e24 * .e13 - .e12/.e2) * .e4 * .e7 - ((.e90 - 
        (.e67/.e2 + 2 * .e28)/.e2) * .e16 + .e12 * .e4 * .e7)/.e2)/(.e103 * 
        .e2) - .e102 * (2 * (.e13 * .e124 * .e4 * .e7) - 2 * 
        (.e103 * .e16/.e30))/.e10^(4 * .e13)) * .e4 * .e7
    .e152 <- ((.e117 * .e16 + .e24 * .e4 * .e7/.e10)/.e68 + (.e102/.e10^(.e27 - 
        2) + .e105 - .e88) * .e4 * .e7)/.e10
    .e154 <- (.e98 - .e31)/.e10 + (.e100 + .e11 + 2) * .e2
    .e156 <- ((.e101 + 1)/.e2 + 2) * .e2 + (.e38 - .e82)/.e10
    .e158 <- .e36 * (.e127 - 2) - .e63
    .e160 <- .e119 * .e16/.e56
    .e167 <- .e10^3
    .e169 <- (2 * .e36 - .e17) * .e2 - .e17
    .e172 <- (2 * (.e123 * .e4 * .e7/.e10) + 2/.e2^3) * .e4 * 
        .e7/.e10
    .e173 <- (2 * ((.e34 * .e4 * .e7 - .e88)/.e10 - .e144) + 
        2 * (.e126/.e10) - 4 * .e144)/.e2
    .e174 <- 2 * (.e59/.e125)
    .e175 <- .e4^3
    .e178 <- .e128 * .e93 * .e4/.e10
    .e179 <- .e128 * t3
    .e180 <- .e149/.e10
    .e182 <- .e146 * .e93 * .e4
    .e183 <- .e93 * .e4
    .e186 <- ((((.e160 - .e174) * .e24 - .e152)/.e10 - .e173)/.e2 + 
        .e151)/.e2 + .e172
    .e188 <- (.e151 - ((.e152 + .e24 * (.e174 - .e160))/.e10 + 
        .e173)/.e2)/.e2 + .e172
    .e191 <- t1 * .e142 * .e85/.e51
    .e194 <- .e128 * .e142 * .e85/.e51
    .e196 <- t2 * .e108 * .e4
    .e198 <- t2 * .e110 * .e4
    .e200 <- t2 * .e113 * .e4
    .e202 <- .e130 * .e108 * .e4
    .e204 <- .e130 * .e110 * .e4
    .e206 <- .e130 * .e113 * .e4
    .e208 <- t3 * .e132 * .e4
    .e210 <- t3 * .e134 * .e4
    .e212 <- t3 * .e139 * .e4
    .e213 <- .e183/.e10
    .e214 <- .e108 * .e4
    .e215 <- .e110 * .e4
    .e216 <- .e113 * .e4
    .e219 <- t1 * .e93 * .e4/.e10
    .e222 <- t1 * .e169 * .e175/.e167
    .e226 <- t1 * .e146 * .e93 * .e4/.e10
    .e227 <- t1 * .e147
    .e230 <- .e145 * .e169 * .e175/.e167
    .e231 <- .e145 * t2
    .e232 <- .e145 * t3
    .e234 <- .e149 * .e7/.e10
    .e235 <- t2 * .e147
    .e237 <- .e182 * .e7/.e10
    .e238 <- .e182/.e10
    .e239 <- .e146 * t3
    .e241 <- t3 * .e108 * .e4
    .e243 <- t3 * .e110 * .e4
    .e245 <- t3 * .e113 * .e4
    .e246 <- -.e216
    .e247 <- -(t1 * .e113 * .e4)
    .e249 <- -(.e128 * .e113 * .e4)
    .e250 <- -(.e179 * .e113 * .e4)
    .e251 <- -(.e129 * .e113 * .e4)
    .e252 <- -(.e129 * .e132 * .e4/.e10)
    .e253 <- -(.e129 * .e134 * .e4)
    .e256 <- -.e200
    .e258 <- -.e206
    .e259 <- -(.e130 * .e132 * .e4 * .e7/.e10)
    .e260 <- -(.e130 * .e134 * .e4 * .e7)
    .e261 <- -(t3 * .e186)
    .e262 <- -.e245
    .e263 <- -(.e208 * .e7/.e10)
    .e264 <- -(.e208/.e10)
    .e265 <- -(.e210 * .e7)
    .e266 <- -.e210
    .e267 <- -(.e147 * .e188)
    .e268 <- .e214/.e10
    .e269 <- .e215/.e10
    .e270 <- .e132 * .e4
    .e271 <- .e134 * .e4
    .e272 <- .e139 * .e4
    .e274 <- .e142 * .e85/.e51
    .e275 <- c(v1 = .e222, v2 = .e230, v3 = .e191, v4 = .e194, 
        v5 = -(t1 * .e95 * .e85), v6 = -(.e129 * .e95 * .e85))
    .e276 <- c(v1 = .e180, v2 = .e178, v3 = .e234, v4 = .e237, 
        v5 = -(.e200 * .e7), v6 = -(.e206 * .e7))
    .e279 <- t1 * .e108 * .e4/.e10
    .e282 <- t1 * .e110 * .e4/.e10
    .e285 <- t1 * .e154 * .e85/.e51
    .e288 <- t1 * .e156 * .e85/.e51
    .e291 <- t1 * .e158 * .e85/.e51
    .e294 <- .e128 * .e108 * .e4/.e10
    .e297 <- .e128 * .e110 * .e4/.e10
    .e300 <- .e128 * .e158 * .e85/.e51
    .e303 <- .e179 * .e108 * .e4/.e10
    .e306 <- .e179 * .e110 * .e4/.e10
    .e309 <- .e129 * .e108 * .e4/.e10
    .e312 <- .e129 * .e110 * .e4/.e10
    .e315 <- .e129 * .e154 * .e85/.e51
    .e318 <- .e129 * .e156 * .e85/.e51
    .e321 <- .e129 * .e139 * .e4/.e51
    .e324 <- .e145 * .e142 * .e85/.e51
    .e327 <- .e231 * .e142 * .e85/.e51
    .e329 <- .e196 * .e7/.e10
    .e330 <- .e196/.e10
    .e332 <- .e198 * .e7/.e10
    .e333 <- .e198/.e10
    .e336 <- t2 * .e142 * .e85/.e51
    .e338 <- .e202 * .e7/.e10
    .e339 <- .e202/.e10
    .e341 <- .e204 * .e7/.e10
    .e342 <- .e204/.e10
    .e346 <- .e130 * .e139 * .e4 * .e7/.e51
    .e347 <- .e241/.e10
    .e348 <- .e243/.e10
    .e350 <- .e212 * .e7/.e51
    .e351 <- .e212/.e51
    .e353 <- .e147 * .e132 * .e4
    .e355 <- .e147 * .e134 * .e4
    .e357 <- .e147 * .e139 * .e4
    c(v1 = c(v1 = c(v1 = .e169 * .e175/.e167, v2 = .e222, v3 = .e274, 
        v4 = .e336, v5 = -(.e95 * .e85), v6 = -(t3 * .e95 * .e85)), 
        v2 = .e275, v3 = c(v1 = .e274, v2 = .e191, v3 = .e213, 
            v4 = .e180, v5 = .e246, v6 = .e262), v4 = c(v1 = .e336, 
            v2 = .e194, v3 = .e180, v4 = .e238, v5 = .e256, v6 = .e258), 
        v5 = c(v1 = .e154 * .e85/.e51, v2 = .e285, v3 = .e268, 
            v4 = .e330, v5 = -(.e270/.e10), v6 = .e264), v6 = c(v1 = t3 * 
            .e154 * .e85/.e51, v2 = .e315, v3 = .e347, v4 = .e339, 
            v5 = .e264, v6 = -(.e353/.e10))), v2 = c(v1 = .e275, 
        v2 = c(v1 = .e230, v2 = t1^3 * .e169 * .e175/.e167, v3 = .e324, 
            v4 = .e327, v5 = -(.e145 * .e95 * .e85), v6 = -(.e232 * 
                .e95 * .e85)), v3 = c(v1 = .e191, v2 = .e324, 
            v3 = .e219, v4 = .e178, v5 = .e247, v6 = .e251), 
        v4 = c(v1 = .e194, v2 = .e327, v3 = .e178, v4 = .e226, 
            v5 = .e249, v6 = .e250), v5 = c(v1 = .e285, v2 = .e145 * 
            .e154 * .e85/.e51, v3 = .e279, v4 = .e294, v5 = -(t1 * 
            .e132 * .e4/.e10), v6 = .e252), v6 = c(v1 = .e315, 
            v2 = .e232 * .e154 * .e85/.e51, v3 = .e309, v4 = .e303, 
            v5 = .e252, v6 = -(.e227 * .e132 * .e4/.e10))), v3 = c(v1 = c(v1 = .e158 * 
        .e85/.e51, v2 = .e291, v3 = .e213, v4 = .e180, v5 = .e246, 
        v6 = .e262), v2 = c(v1 = .e291, v2 = .e145 * .e158 * 
        .e85/.e51, v3 = .e219, v4 = .e178, v5 = .e247, v6 = .e251), 
        v3 = c(v1 = .e213, v2 = .e219, v3 = .e183 * .e7/.e10, 
            v4 = .e234, v5 = -(.e216 * .e7), v6 = -(.e245 * .e7)), 
        v4 = .e276, v5 = c(v1 = .e268, v2 = .e279, v3 = .e214 * 
            .e7/.e10, v4 = .e329, v5 = -(.e270 * .e7/.e10), v6 = .e263), 
        v6 = c(v1 = .e347, v2 = .e309, v3 = .e241 * .e7/.e10, 
            v4 = .e338, v5 = .e263, v6 = -(.e353 * .e7/.e10))), 
        v4 = c(v1 = c(v1 = t2 * .e158 * .e85/.e51, v2 = .e300, 
            v3 = .e180, v4 = .e238, v5 = .e256, v6 = .e258), 
            v2 = c(v1 = .e300, v2 = .e231 * .e158 * .e85/.e51, 
                v3 = .e178, v4 = .e226, v5 = .e249, v6 = .e250), 
            v3 = .e276, v4 = c(v1 = .e238, v2 = .e226, v3 = .e237, 
                v4 = t2^3 * .e93 * .e4 * .e7/.e10, v5 = -(.e146 * 
                  .e113 * .e4 * .e7), v6 = -(.e239 * .e113 * 
                  .e4 * .e7)), v5 = c(v1 = .e330, v2 = .e294, 
                v3 = .e329, v4 = .e146 * .e108 * .e4 * .e7/.e10, 
                v5 = -(t2 * .e132 * .e4 * .e7/.e10), v6 = .e259), 
            v6 = c(v1 = .e339, v2 = .e303, v3 = .e338, v4 = .e239 * 
                .e108 * .e4 * .e7/.e10, v5 = .e259, v6 = -(.e235 * 
                .e132 * .e4 * .e7/.e10))), v5 = c(v1 = c(v1 = .e156 * 
            .e85/.e51, v2 = .e288, v3 = .e269, v4 = .e333, v5 = -.e271, 
            v6 = .e266), v2 = c(v1 = .e288, v2 = .e145 * .e156 * 
            .e85/.e51, v3 = .e282, v4 = .e297, v5 = -(t1 * .e134 * 
            .e4), v6 = .e253), v3 = c(v1 = .e269, v2 = .e282, 
            v3 = .e215 * .e7/.e10, v4 = .e332, v5 = -(.e271 * 
                .e7), v6 = .e265), v4 = c(v1 = .e333, v2 = .e297, 
            v3 = .e332, v4 = .e146 * .e110 * .e4 * .e7/.e10, 
            v5 = -(t2 * .e134 * .e4 * .e7), v6 = .e260), v5 = c(v1 = .e272/.e51, 
            v2 = t1 * .e139 * .e4/.e51, v3 = .e272 * .e7/.e51, 
            v4 = t2 * .e139 * .e4 * .e7/.e51, v5 = -.e186, v6 = .e261), 
            v6 = c(v1 = .e351, v2 = .e321, v3 = .e350, v4 = .e346, 
                v5 = .e261, v6 = -(.e147 * .e186))), v6 = c(v1 = c(v1 = t3 * 
            .e156 * .e85/.e51, v2 = .e318, v3 = .e348, v4 = .e342, 
            v5 = .e266, v6 = -.e355), v2 = c(v1 = .e318, v2 = .e232 * 
            .e156 * .e85/.e51, v3 = .e312, v4 = .e306, v5 = .e253, 
            v6 = -(.e227 * .e134 * .e4)), v3 = c(v1 = .e348, 
            v2 = .e312, v3 = .e243 * .e7/.e10, v4 = .e341, v5 = .e265, 
            v6 = -(.e355 * .e7)), v4 = c(v1 = .e342, v2 = .e306, 
            v3 = .e341, v4 = .e239 * .e110 * .e4 * .e7/.e10, 
            v5 = .e260, v6 = -(.e235 * .e134 * .e4 * .e7)), v5 = c(v1 = .e351, 
            v2 = .e321, v3 = .e350, v4 = .e346, v5 = -(t3 * .e188), 
            v6 = .e267), v6 = c(v1 = .e357/.e51, v2 = .e227 * 
            .e139 * .e4/.e51, v3 = .e357 * .e7/.e51, v4 = .e235 * 
            .e139 * .e4 * .e7/.e51, v5 = .e267, v6 = -(t3^3 * 
            .e188))))
}
############################################################
#' The first derivative of the density
#' @returns Vector
#' @inheritParams manf
gev_p123_f1fa=function(x,t01,t02,t03,v1,v2,v3,v4,v5,v6){

	v3=movexiawayfromzero(v3)

	vf=Vectorize(gev_p123_fd)
	f1=vf(x,t01,t02,t03,v1,v2,v3,v4,v5,v6)
	return(f1)
}
############################################################
#' The second derivative of the density
#' @returns Matrix
#' @inheritParams manf
gev_p123_f2fa=function(x,t01,t02,t03,v1,v2,v3,v4,v5,v6){
	nx=length(x)

	v3=movexiawayfromzero(v3)

	vf=Vectorize(gev_p123_fdd)
	temp1=vf(x,t01,t02,t03,v1,v2,v3,v4,v5,v6)
	f2=deriv_copyfdd(temp1,nx,dim=6)
	return(f2)
}
############################################################
#' Minus the first derivative of the cdf, at alpha
#' @returns Vector
#' @inheritParams manf
gev_p123_mu1fa=function(alpha,t01,t02,t03,v1,v2,v3,v4,v5,v6){
	x=qgev((1-alpha),mu=v1+v2*t01,sigma=exp(v3+v4*t02),xi=v5+v6*t03)

	v3=movexiawayfromzero(v3)

	vf=Vectorize(gev_p123_pd)
	mu1=-vf(x,t01,t02,t03,v1,v2,v3,v4,v5,v6)
	return(mu1)
}
############################################################
#' Minus the second derivative of the cdf, at alpha
#' @returns Matrix
#' @inheritParams manf
gev_p123_mu2fa=function(alpha,t01,t02,t03,v1,v2,v3,v4,v5,v6){
	x=qgev((1-alpha),mu=v1+v2*t01,sigma=exp(v3+v4*t02),xi=v5+v6*t03)
	nx=length(x)

	v3=movexiawayfromzero(v3)

	vf=Vectorize(gev_p123_pdd)
	temp1=vf(x,t01,t02,t03,v1,v2,v3,v4,v5,v6)
	mu2=-deriv_copyfdd(temp1,nx,dim=6)
	return(mu2)
}
############################################################
#' The second derivative of the normalized log-likelihood
#' @returns Matrix
#' @inheritParams manf
gev_p123_ldda=function(x,t1,t2,t3,v1,v2,v3,v4,v5,v6){
	nx=length(x)

	v3=movexiawayfromzero(v3)

	vf=Vectorize(gev_p123_logfdd)
	temp1=vf(x,t1,t2,t3,v1,v2,v3,v4,v5,v6)
	ldd=deriv_copyldd(temp1,nx,dim=6)
	return(ldd)
}
############################################################
#' The third derivative of the normalized log-likelihood
#' @returns 3d array
#' @inheritParams manf
gev_p123_lddda=function(x,t1,t2,t3,v1,v2,v3,v4,v5,v6){
	nx=length(x)

	v3=movexiawayfromzero(v3)

	vf=Vectorize(gev_p123_logfddd)
	temp1=vf(x,t1,t2,t3,v1,v2,v3,v4,v5,v6)
	lddd=deriv_copylddd(temp1,nx,dim=6)
	return(lddd)
}
