% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitter.R
\name{fitter}
\alias{fitter}
\title{Fit distributions to empirical data}
\usage{
fitter(X, dom = "discrete", freq = NULL, R = 100, timeout = 5,
  posList = NULL, fast = TRUE)
}
\arguments{
\item{X}{A numeric vector}

\item{dom}{A string specifying the domain of \sQuote{X}}

\item{freq}{The frequency of values in \sQuote{X}. See details.}

\item{R}{An integer specifying the number of bootstraps. See details.}

\item{timeout}{An numeric value specifying the maximum time spend for a fit}

\item{posList}{A list. See details.}

\item{fast}{A logical. See details.}
}
\value{
A list serving as an unformatted report summarizing the fitting.
}
\description{
Fits theoretical univariate distributions from the R universe to a given set of empirical observations
}
\details{
This routine is the workhorse of the package. It takes empirical data and systematically tries to fit numerous distributions implemented in R packages to this data.
Sometimes the empirical data is passed as a histogram. In this case \sQuote{X} takes the support and \sQuote{freq} takes the number of occurences of each value in \sQuote{X}. Although not limited to, this makes most sense for discrete data. 
If there is prior knowledge (or guessing) about candidate theoretical distributions, these can be specified by \sQuote{posList}. This parameter takes a list with names of items being the package name and items being a character vector containing names of the distribtions (with prefix 'd'). If all distributions of a package should be applied, this vector is set to \code{NA}.
Fitting of some distributions can be very slow. They can be skipped if \sQuote{fast} is set to \code{TRUE}.
}
\note{
To reduce the computational efforts, usage of the parameter \sQuote{posList} is recommended. If not specified, the function will try to perform fits to distributions from _ALL_ packages listed in \code{\link{supported.packages}}.
}
\examples{
# continous empirical data
x <- rnorm(1000, 50, 3)
if(requireNamespace("ExtDist")){
r <- fitter(x, dom="c", posList=list(stats=c("dexp"), ExtDist=c("dCauchy")))
}else{
r <- fitter(x, dom="c", posList=list(stats=c("dexp", "dt")))
}

# discrete empirical data
x <- rnbinom(100, 0.5, 0.2)
r <- fitter(x, dom="dis", posList=list(stats=NA))

}
\seealso{
\code{\link{printReport}} for post-processing of all fits
}
\author{
Markus Boenn
}
