% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{plot_qq}
\alias{plot_qq}
\title{Q-Q Plot}
\usage{
plot_qq(x, fits)
}
\arguments{
\item{x}{numeric vector of sample data}

\item{fits}{a list object produced from fit_univariate, fit_empirical, or
fit_univariate_man}
}
\value{
ggplot of quantile-quantile comparison of theoretical distribution
}
\description{
Q-Q Plot
}
\examples{
library(ggplot2)
set.seed(37)
x <- rgamma(10000, 5)
dists <- c('gamma', 'lnorm', 'weibull')
fits <- lapply(dists, fit_univariate, x = x)
plot_qq(x, fits) +
theme_bw()
}
