% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{plot.fixest.fixef}
\alias{plot.fixest.fixef}
\title{Displaying the most notable fixed-effects}
\usage{
\method{plot}{fixest.fixef}(x, n = 5, ...)
}
\arguments{
\item{x}{An object obtained from the function \code{\link{fixef.fixest}}.}

\item{n}{The number of fixed-effects to be drawn. Defaults to 5.}

\item{...}{Not currently used.

Note that the fixed-effect coefficients might NOT be interpretable. This function is useful only for fully regular panels.

If the data are not regular in the fixed-effect coefficients, this means that several \sQuote{reference points} are set to obtain the fixed-effects, thereby impeding their interpretation. In this case a warning is raised.}
}
\description{
This function plots the 5 fixed-effects with the highest and lowest values, for each of the fixed-effect dimension. It takes as an argument the fixed-effects obtained from the function \code{\link{fixef.fixest}} after an estimation using \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}.
}
\examples{

data(trade)

# We estimate the effect of distance on trade
# => we account for 3 fixed-effects
est_pois = femlm(Euros ~ log(dist_km)|Origin+Destination+Product, trade)

# obtaining the fixed-effects coefficients
fe_trade = fixef(est_pois)

# plotting them
plot(fe_trade)


}
\seealso{
\code{\link[fixest]{fixef.fixest}} to extract clouster coefficients. See also the main estimation function \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}. Use \code{\link[fixest]{summary.fixest}} to see the results with the appropriate standard-errors, the function \code{\link[fixest]{etable}} to visualize the results of multiple estimations.
}
\author{
Laurent Berge
}
