% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-split.R
\name{split_sandwiches}
\alias{split_sandwiches}
\title{Separates a string into sections by delimiter}
\usage{
split_sandwiches(.string, start_rx, end_rx = NULL)
}
\arguments{
\item{.string}{A string}

\item{start_rx}{A regular expression denoting the beginning of a section.  Use \code{fixed()} for literals.}

\item{end_rx}{A regular expression denoting the end of a section.  If none supplied, sections end when the next \code{start_rx} is encountered.}
}
\value{
A vector of strings
}
\description{
This function takes delimiters for the beginning and (optionally, if different) end of sections of a string, and returns a vector with split string elements.
}
\details{
The main use case for \code{split_sandwiches()} is for html editing: You might want to separate the original text from the html tags, make certain edits to the text only, and then re-wrap the tags.

This is different from \code{str_split()} or similar, because the delimiters are preserved and remain attached to a section.

Note that \code{split_sandwiches()} is not vectorized (sorry).  It only takes a single character object.
}
\examples{
my_string <- "<span style='text-color:blue'> I am blue and <b>bold</b>, yay! </span>"

split_sandwiches(my_string, "\\\\<[^\\\\>\\\\<]*\\\\>")

}
