% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut3.R
\name{cut3}
\alias{cut3}
\title{Modified cut}
\usage{
cut3(x, breaks, labels = NULL, include.lowest = FALSE, right = TRUE,
  dig.lab = 3L, ordered_result = FALSE, sep = ", ", ...)
}
\arguments{
\item{x}{Numeric vector.}

\item{breaks}{Numeric vector of cut points or a single number specifying the number of intervals desired.}

\item{labels}{Labels for the levels of the final categories.}

\item{include.lowest}{Flag if minimum value should be added to intervals of type (,] (or maximum for [, )).}

\item{right}{Flag if intervals should be closed to the right or left.}

\item{dig.lab}{Number of significant digits passed to formatC.}

\item{ordered_result}{Flag if resulting output vector should be ordered.}

\item{sep}{Separater between from-to labels.}

\item{...}{Arguments passed to \code{formatC}.}
}
\value{
Vector of the same length as x.
}
\description{
Slightly modified version of base::cut.default. Both modifications refer to the construction of break labels. Firstly, ... arguments are passed to \code{formatC} in formatting the numbers in the labels. Secondly, a separator between the two numbers can be specified with default ", ".
}
\examples{
x <- 998:1001
cut3(x, breaks = 2)
cut3(x, breaks = 2, big.mark = "'", sep = ":")
}
