% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_light_breakdown.R
\name{plot.light_breakdown}
\alias{plot.light_breakdown}
\title{Visualize Variable Contribution Breakdown for Single Observation}
\usage{
\method{plot}{light_breakdown}(x, facet_scales = "free",
  facet_ncol = 1, ...)
}
\arguments{
\item{x}{An object of class \code{light_breakdown}.}

\item{facet_scales}{Scales argument passed to \code{facet_wrap}.}

\item{facet_ncol}{\code{ncol} argument passed to \code{facet_wrap}.}

\item{...}{Further arguments passed to \code{geom_label}.}
}
\value{
An object of class \code{ggplot2}.
}
\description{
Minimal visualization of an object of class \code{light_breakdown} as waterfall plot. The object returned is of class \code{ggplot} and can be further customized.
}
\details{
The waterfall plot is to be read from top to bottom. The first line describes the (weighted) average prediction in the query data used to start with. Then, each additional line shows how the prediction changes due to the impact of the corresponding variable. The last line finally shows the original prediction of the selected observation. Multiple flashlights are shown in different facets. Positive and negative impacts are visualized with different colors.
}
\examples{
fit_full <- lm(Sepal.Length ~ ., data = iris)
fit_part <- lm(Sepal.Length ~ Petal.Length, data = iris)
mod_full <- flashlight(model = fit_full, label = "full", data = iris, y = "Sepal.Length")
mod_part <- flashlight(model = fit_part, label = "part", data = iris, y = "Sepal.Length")
mods <- multiflashlight(list(mod_full, mod_part))

plot(x <- light_breakdown(mod_full, new_obs = iris[1, ]))
plot(light_breakdown(mods, new_obs = iris[1, ]), size = 2.5)
plot(light_breakdown(mods, new_obs = iris[1, ]), facet_ncol = 2)
}
\seealso{
\code{\link{light_importance}}.
}
