% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_global_surrogate.R
\name{light_global_surrogate}
\alias{light_global_surrogate}
\alias{light_global_surrogate.default}
\alias{light_global_surrogate.flashlight}
\alias{light_global_surrogate.multiflashlight}
\title{Global Surrogate Tree}
\usage{
light_global_surrogate(x, ...)

\method{light_global_surrogate}{default}(x, ...)

\method{light_global_surrogate}{flashlight}(
  x,
  data = x$data,
  by = x$by,
  v = NULL,
  use_linkinv = TRUE,
  n_max = Inf,
  seed = NULL,
  keep_max_levels = 4,
  label_name = "label",
  tree_name = "tree",
  ...
)

\method{light_global_surrogate}{multiflashlight}(x, ...)
}
\arguments{
\item{x}{An object of class \code{flashlight} or \code{multiflashlight}.}

\item{...}{Arguments passed to \code{rpart}, such as \code{maxdepth}.}

\item{data}{An optional \code{data.frame}.}

\item{by}{An optional vector of column names used to additionally group the results. For each group, a separate tree is grown.}

\item{v}{Vector of variables used in the surrogate model. Defaults to all variables in \code{data} except "by", "w" and "y".}

\item{use_linkinv}{Should retransformation function be applied? Default is \code{TRUE}.}

\item{n_max}{Maximum number of data rows to consider to build the tree.}

\item{seed}{An integer random seed used to select data rows if \code{n_max} is lower than the number of data rows.}

\item{keep_max_levels}{Number of levels of categorical and factor variables to keep. Other levels are combined to a level "Other". This prevents \code{rpart} to take too long to split non-numeric variables with many levels.}

\item{label_name}{Column name in resulting \code{data} containing the label of the flashlight. Defaults to "label".}

\item{tree_name}{Column name in resulting \code{data} containing the trees. Defaults to "tree".}
}
\value{
An object of class \code{light_global_surrogate}, \code{light} (and a list) with the following elements.
\itemize{
\item \code{data} A tibble with results. Can be used to build fully customized visualizations.
\item \code{by} Same as input \code{by}.
\item \code{label_name} Same as input \code{label_name}.
\item \code{tree_name} Name of column with tree objects.
}
}
\description{
Model predictions are modelled by a single decision tree, serving as an easy to interprete surrogate to the original model. As suggested in Molnar (see reference below), the quality of the surrogate tree can be measured by its R-squared.
}
\details{
The size of the tree can be modified by passing \code{...} arguments to \code{rpart}.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method not implemented yet.

\item \code{flashlight}: Surrogate model for a flashlight.

\item \code{multiflashlight}: Surrogate model for a multiflashlight.
}}

\examples{
fit1 <- lm(Sepal.Length ~ ., data = iris)
fit2 <- lm(Sepal.Length ~ Petal.Length, data = iris)
fl1 <- flashlight(model = fit1, label = "full")
fl2 <- flashlight(model = fit2, label = "partial")
fls <- multiflashlight(list(fl1, fl2), data = iris, y = "Sepal.Length")
light_global_surrogate(fls, maxdepth = 3)

}
\references{
Molnar C. (2019). Interpretable Machine Learning.
}
\seealso{
\code{\link{plot.light_global_surrogate}}.
}
