% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rkhist.R
\name{rkhist.matrix}
\alias{rkhist.matrix}
\title{Method of S3 generic function \code{rkhist} for \code{matrix} objects}
\usage{
\method{rkhist}{matrix}(fcst, obs, names = NULL, ...)
}
\arguments{
\item{fcst}{an object containing the ensemble forecasts. It must be a matrix,
each row containing a forecast.}

\item{obs}{an object containing the observation associated to the forecast in
\code{fcst}. It can be a vector or a matrix, whose length is the same as
the number of row in \code{fcst}}

\item{names}{a character vector. The row names in the returned \code{rkhist}
object.}

\item{...}{additional arguments, passed to function \code{base::rank}.}
}
\value{
An S3 object of class \code{rkhist} (indeed just 1-row matrix
containing the count for each rank, with \code{class == "rkhist"}).
}
\description{
This is the method called when the \code{fcst} argument in function
\code{rkhist} is a matrix.
}
