% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_headers.R
\name{add_body}
\alias{add_body}
\title{Add rows in body part}
\usage{
add_body(x, top = TRUE, ..., values = NULL)
}
\arguments{
\item{x}{a \code{flextable} object}

\item{top}{should the rows be inserted at the top or the bottom.}

\item{...}{a named list (names are data colnames) of strings
specifying corresponding values to add. It is important
to insert data of the same type as the original data,
otherwise it will be transformed (probably into strings if
you add a \verb{character' where a }double' is expected). This keeps
the ability to format cell contents with the \verb{colformat_*} functions,
for example \code{\link[=colformat_num]{colformat_num()}}.}

\item{values}{a list of name-value pairs of labels or values,
names should be existing col_key values. This argument can be used
instead of \code{...} for programming purpose (If \code{values} is
supplied argument \code{...} is ignored).}
}
\description{
Add rows in the flextable's body.
It can be inserted at the top or the bottom.
The function is column oriented, labels are specified for each columns, there
can be more than a value - resulting in more than a new row.
}
\examples{
ft <- flextable(head(iris),
  col_keys = c(
    "Species", "Sepal.Length", "Petal.Length",
    "Sepal.Width", "Petal.Width"
  )
)

ft <- add_body(
  x = ft, Sepal.Length = 1:5,
  Sepal.Width = 1:5 * 2, Petal.Length = 1:5 * 3,
  Petal.Width = 1:5 + 10, Species = "Blah", top = FALSE
)

ft <- theme_booktabs(ft)
ft
}
\seealso{
\code{\link[=flextable]{flextable()}}, \code{\link[=add_header]{add_header()}}, \code{\link[=add_footer]{add_footer()}}
}
