% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flextable.R
\name{as_flextable.glm}
\alias{as_flextable.glm}
\title{tabular summary for glm object}
\usage{
\method{as_flextable}{glm}(x, ...)
}
\arguments{
\item{x}{glm model}

\item{...}{unused argument}
}
\description{
produce a flextable describing a
generalized linear model produced by function \code{glm}.
}
\section{Illustrations}{


\if{html}{\figure{fig_as_flextable.glm_1.png}{options: width=60\%}}
}

\examples{
if(require("broom")){
  dat <- attitude
  dat$high.rating <- (dat$rating > 70)
  probit.model <- glm(high.rating ~ learning + critical +
     advance, data=dat, family = binomial(link = "probit"))
  ft <- as_flextable(probit.model)
  ft
}
}
\seealso{
Other as_flextable methods: 
\code{\link{as_flextable.gam}()},
\code{\link{as_flextable.grouped_data}()},
\code{\link{as_flextable.htest}()},
\code{\link{as_flextable.lm}()},
\code{\link{as_flextable.xtable}()},
\code{\link{as_flextable}()}
}
\concept{as_flextable methods}
