% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable_sizes.R
\name{dim_pretty}
\alias{dim_pretty}
\title{Calculate pretty dimensions}
\usage{
dim_pretty(x, part = "all", unit = "in", hspans = "none")
}
\arguments{
\item{x}{flextable object}

\item{part}{partname of the table (one of 'all', 'body', 'header' or 'footer')}

\item{unit}{unit for returned values, one of "in", "cm", "mm".}

\item{hspans}{specifies how cells that are horizontally are included in the calculation.
It must be one of the following values "none", "divided" or "included". If
"none", widths of horizontally spanned cells is set to 0 (then do not affect the
widths); if "divided", widths of horizontally spanned cells is divided by
the number of spanned cells; if "included", all widths (included horizontally
spanned cells) will be used in the calculation.}
}
\description{
return minimum estimated widths and heights for
each table columns and rows in inches.
}
\examples{
ftab <- flextable(head(mtcars))
dim_pretty(ftab)
}
\seealso{
Other flextable dimensions: 
\code{\link{autofit}()},
\code{\link{dim.flextable}()},
\code{\link{fit_to_width}()},
\code{\link{flextable_dim}()},
\code{\link{height}()},
\code{\link{hrule}()},
\code{\link{ncol_keys}()},
\code{\link{nrow_part}()},
\code{\link{set_table_properties}()},
\code{\link{width}()}
}
\concept{flextable dimensions}
