% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk_images.R
\name{as_image}
\alias{as_image}
\title{Image chunk wrapper}
\usage{
as_image(src, width = NULL, height = NULL, unit = "in", guess_size = TRUE, ...)
}
\arguments{
\item{src}{image filename}

\item{width, height}{size of the image file. It can be ignored
if parameter \code{guess_size=TRUE}, see parameter \code{guess_size}.}

\item{unit}{unit for width and height, one of "in", "cm", "mm".}

\item{guess_size}{If package 'magick' is installed, this option
can be used (set it to \code{TRUE} and don't provide values for paramters
\code{width} and \code{height}). When the flextable will be printed,
the images will be read and width and height will be guessed. This
should be avoid if possible as it can be an extensive task when
several images.}

\item{...}{unused argument}
}
\description{
The function lets add images within flextable
objects with functions:
\itemize{
\item \code{\link[=compose]{compose()}} and \code{\link[=as_paragraph]{as_paragraph()}},
\item \code{\link[=append_chunks]{append_chunks()}},
\item \code{\link[=prepend_chunks]{prepend_chunks()}}
\if{html}{\out{
<img src="https://www.ardata.fr/img/flextable-imgs/flextable-006.png" alt="as_image illustration" style="width:100\%;">
}}
}
}
\note{
This chunk option requires package officedown in a R Markdown
context with Word output format.

PowerPoint cannot mix images and text in a paragraph, images
are removed when outputing to PowerPoint format.
}
\examples{
img.file <- file.path(
  R.home("doc"),
  "html", "logo.jpg"
)
if (require("magick")) {
  myft <- flextable(head(iris))
  myft <- compose(myft,
    i = 1:3, j = 1,
    value = as_paragraph(
      as_image(src = img.file),
      " ",
      as_chunk(Sepal.Length,
        props = fp_text_default(color = "red")
      )
    ),
    part = "body"
  )
  ft <- autofit(myft)
  ft
}
}
\seealso{
\code{\link[=compose]{compose()}}, \code{\link[=as_paragraph]{as_paragraph()}}

Other chunk elements for paragraph: 
\code{\link{as_bracket}()},
\code{\link{as_b}()},
\code{\link{as_chunk}()},
\code{\link{as_equation}()},
\code{\link{as_highlight}()},
\code{\link{as_i}()},
\code{\link{as_sub}()},
\code{\link{as_sup}()},
\code{\link{as_word_field}()},
\code{\link{colorize}()},
\code{\link{gg_chunk}()},
\code{\link{grid_chunk}()},
\code{\link{hyperlink_text}()},
\code{\link{linerange}()},
\code{\link{lollipop}()},
\code{\link{minibar}()},
\code{\link{plot_chunk}()}
}
\concept{chunk elements for paragraph}
