% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/body_add_flextable.R
\name{body_add_flextable}
\alias{body_add_flextable}
\title{Add flextable into a Word document}
\usage{
body_add_flextable(
  x,
  value,
  align = NULL,
  pos = "after",
  split = NULL,
  topcaption = TRUE,
  keepnext = NULL
)
}
\arguments{
\item{x}{an rdocx object}

\item{value}{\code{flextable} object}

\item{align}{left, center (default) or right.}

\item{pos}{where to add the flextable relative to the cursor,
one of "after", "before", "on" (end of line).}

\item{split}{set to TRUE if you want to activate Word
option 'Allow row to break across pages'.}

\item{topcaption}{if TRUE caption is added before the table, if FALSE,
caption is added after the table.}

\item{keepnext}{Defunct in favor of \code{\link[=paginate]{paginate()}}.}
}
\description{
add a flextable into a Word document.
}
\examples{
library(officer)

# autonum for caption
autonum <- run_autonum(seq_id = "tab", bkm = "mtcars")

ftab <- flextable(head(mtcars))
ftab <- set_caption(ftab, caption = "mtcars data", autonum = autonum)
ftab <- autofit(ftab)
doc <- read_docx()
doc <- body_add_flextable(doc, value = ftab)
fileout <- tempfile(fileext = ".docx")
# fileout <- "test.docx" # uncomment to write in your working directory
print(doc, target = fileout)
}
