% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_airfares.R
\name{get_airfares_url}
\alias{get_airfares_url}
\title{Put together the url of airfare data files}
\usage{
get_airfares_url(dom, date = parent.frame()$date)
}
\arguments{
\item{dom}{Logical. Defaults to \code{TRUE} download airfares of domestic
flights. If \code{FALSE}, the function downloads airfares of
international flights.}

\item{date}{Numeric. Date of the data in the format \code{yyyymm}. To download the
data for all months in a year, the user can pass a 4-digit year
input \code{yyyy}. The parameter also accepts a vector of dates such as
\code{c(202001, 202006, 202012)}.}
}
\value{
A url string.
}
\description{
Put together the url of airfare data files
}
\examples{
\dontrun{ if (interactive()) {
# Generate url
a <- get_airfares_url(year=2002, month=11)
}}
}
\keyword{internal}
