% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowDiv_main.R
\name{flowDiv}
\alias{flowDiv}
\title{Cytometric Diversity Indices from Gated Data}
\usage{
flowDiv(myworkspaces, gate.name=NULL, ialpha="invsimpson", ibeta="bray", do.plot=FALSE,

static=FALSE, dilutions=NULL,  pmax=0.05, env=NULL, use.beads=FALSE, beads=NULL,

transform.hell=FALSE, dimension=20, psize=3, autotrans=FALSE)
}
\arguments{
\item{myworkspaces}{A list containing the paths to FlowJo workspaces or GatingSet which are meant to be analyzed. More than one workspace can be analyzed at the same time. Workspaces should contain .fcs files (versions 2.0 or 3.0) with its original names.}

\item{gate.name}{Name of the gate to be analyzed. Must be a single-valued string. The gate should be named exactly the same in all samples from the workspaces.}

\item{ialpha}{Method used to calculate alpha diversity index of cytograms (i.e. the degree of similarity between two cytograms). Should be one of "shannon", "simpson" or "invsimpson", as for vegan::diversity function. Default is "invsimpson".}

\item{ibeta}{Method used to calculate beta diversity index of cytograms. Should be one of  the sixteeen avaiable for vegan::vegdist function. Default is “bray”.}

\item{do.plot}{Logical. It plots scatterplots of gated populations and displays grid lines corresponding to the limits of the bins.}

\item{static}{Logical. If TRUE, one must set minimum and maximum range for each channel individually.}

\item{dilutions}{A vector containing dilution factors for each sample in the workspaces. Its lenght is the same as the total number of samples meant to be analyzed and must follow the exact same order in which samples are presented to the function (the order of samples corresponds both to the order of workspace described in "myworkspaces" parameter and their order in each of these FlowJo workspaces). By default, it is assumed that all samples have no dilutions whatsoever (i.e. all dilutions factors equal 1).}

\item{pmax}{Maximum estimated p value for displayed variables on NMDS plot, as required by vegan::plot.envifit}

\item{env}{Enviromental matrix associated to the set of cytograms under analysis.}

\item{use.beads}{Logical. If “TRUE” , it centers all cytograms under a common point, based on the arithmetic mean of a standard region for all cytograms (usually beads regions), before proceeding to analysis. It is recommended to proceed this way only if samples were analyzed with different settings.}

\item{beads}{Name of the gate describing the standard region to be used (usually bead's regions). Necessary only if use.beads is set to “TRUE”. The beads gate should be named exactly the same in all samples from the workspaces.}

\item{transform.hell}{Logical. If TRUE, Hellinger transformation is applyed to data before analysis.}

\item{dimension}{Dimensions of plot devices, in centimeters.}

\item{psize}{Defines the plotting size of bins.}

\item{autotrans}{Logical. Argument to be passed to vegan::metaMDS function.}
}
\value{
A list containing alpha index, beta matrix and Pielou's indices for each cytogram.
}
\description{
Uses multidimensional contingency tables to calculate ecological diversity indices from gated populations.
}
\examples{
\dontrun{


# Analyzing a .xml FlowJo workspace.

indexes <- flowDiv(myworkspaces = “my_workspace.xml”,gate.name = “my_gate_name”)
#assume that the FlowJo workspace is below the current directory


}
}
\references{
Li, W.K.W. (1997). Cytometric diversity in marine ultraphytoplankton. Limnology and Oceanography 42, 874–880.
}
\author{
Bruno M.S. Wanderley, Maria Victoria Quiroga, Andre M. Amado, Fernando Unrein
}
