% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{ffi_metadata_match}
\alias{ffi_metadata_match}
\title{Match metadata info with a vector of data timestamps}
\usage{
ffi_metadata_match(data_timestamps, start_dates, start_times, obs_lengths)
}
\arguments{
\item{data_timestamps}{Data timestamps, either character (YYYY-MM-DD HH:MM:SS) or \code{\link{POSIXct}}}

\item{start_dates}{Metadata measurement dates, either character
(YYYY-MM-DD) or \code{\link{POSIXct}}}

\item{start_times}{Metadata measurement start time entries, either character (HH:MM:SS) or \code{\link[lubridate]{period}}}

\item{obs_lengths}{Observation lengths in seconds, numeric; must be same
length as \code{start_dates}. This should include both the intended
measurement period as well as any dead band time at the beginning}
}
\value{
A numeric vector equal in length to \code{data_timestamps}, with
each entry indicating the metadata entry that should be used for that
observation. \code{NA} is returned if a timestamp has no match in the metadata (i.e., does not
fall within any window defined by the \code{start_dates}, \code{start_times},
and observation length parameters).
}
\description{
Match metadata info with a vector of data timestamps
}
\note{
If \code{data_timestamps} or \code{start_dates} cannot be parsed as
YYYY-MM-DD, the preferred format, then MM/DD/YYYY (used by U.S. versions of
Microsoft Excel when saving CSV files, for example) will be tried.
}
\examples{
# Data timestamps
d_t <- c("2024-01-01 13:00:05", "2024-01-01 13:00:10",
"2024-01-01 13:05:05", "2024-01-01 13:10:00")
# Metadata start dates and times: two measurements, starting 5 minutes apart
s_d <- c("2024-01-01", "2024-01-01")
s_t <- c("13:00:00", "13:05:00")
ol <- c(60, 60) # Observation lengths
ffi_metadata_match(d_t, s_d, s_t, ol)
# Returns {1, 1, 2, NA} indicating that the first and second data timestamps
# correspond to metadata entry 1, the third to entry 2, and the fourth
# has no match

# This generates an error because of overlapping timestamps:
\dontrun{
s_t <- c("13:00:00", "13:01:00")
ffi_metadata_match(d_t, s_d, s_t, ol)
}
}
