% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_rds.R
\name{export_rds}
\alias{export_rds}
\title{Write RDS files}
\usage{
export_rds(x, file, FUN = saveRDS,
  data_source = flyio_get_datasource(),
  bucket = flyio_get_bucket(data_source), dir = flyio_get_dir(),
  delete_file = TRUE, ...)
}
\arguments{
\item{x}{variable name}

\item{file}{path of the file to be written to}

\item{FUN}{the function using which the file is to write}

\item{data_source}{the name of the data source, if not set globally. s3, gcs or local}

\item{bucket}{the name of the bucket, if not set globally}

\item{dir}{the directory to store intermediate files}

\item{delete_file}{logical. to delete the file to be uploaded}

\item{...}{other parameters for the FUN function defined above}
}
\value{
if FUN returns anything
}
\description{
Write R data RDS file to anywhere from R
}
\examples{
\dontrun{
# save RDS on Google Cloud
flyio_set_datasource("gcs")
flyio_set_bucket("your-bucket-name")
export_rds(iris, "iris-on-cloud.rds", saveRDS, dir = tempdir())
}
}
