% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_3d.R
\name{as.triangles3d.fm_mesh_3d}
\alias{as.triangles3d.fm_mesh_3d}
\title{Convert a 3D mesh to a 3D rgl triangulation}
\usage{
as.triangles3d.fm_mesh_3d(obj, subset = NULL, ...)
}
\arguments{
\item{obj}{An \code{fm_mesh_3d} object}

\item{subset}{Character string specifying which triangles to extract. Either
"all" (default) or "boundary".}

\item{\dots}{Currently unused}
}
\value{
A 3-column matrix of coordinates of triangles, suitable for
passing to \code{rgl::triangles3d()}.
}
\description{
Extracts a matrix of coordinates of triangles, suitable for
passing to \code{rgl::triangles3d()}.
}
\examples{
# Protect against unavailable rgl device by only running interactively
if (interactive() &&
  requireNamespace("geometry", quietly = TRUE) &&
  requireNamespace("rgl", quietly = TRUE)) {
  (m <- fm_delaunay_3d(matrix(rnorm(30), 10, 3)))
  rgl::open3d()
  rgl::triangles3d(rgl::as.triangles3d(m, "boundary"), col = "blue")
  rgl::axes3d()
}

}
