% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{fmt_range}
\alias{fmt_range}
\title{Formatted Range}
\usage{
fmt_range(x, format = "\%s", sep = "-")
}
\arguments{
\item{x}{The input data vector or data frame column.}

\item{format}{A formatting string suitable for input into the 
\code{\link[base]{sprintf}} function.  By default, this format is
defined as "\%s", which simply converts the value to a string with no
specific formatting.}

\item{sep}{The token used to separate the minimum and maximum range
values.  Default value is a hyphen ("-").}
}
\value{
The formatted range values.
}
\description{
A function to calculate and format a numeric range.
}
\details{
This function calculates a range using the Base R \code{\link[base]{range}}
function, and then formats the output using \code{\link[base]{sprintf}}.
You may control the format using the \strong{format} parameter.  Any NA values
in the input data are ignored. Results are returned as a character vector.
}
\examples{
# Create example vector
v1 <- c(4.3, 3.7, 8.7, 6.1, 9.2, 5.6, NA, 0.7, 7.8, 4.9)

# Format range
fmt_range(v1)

# Output
# "0.7 - 9.2"
}
\seealso{
Other helpers: 
\code{\link{fmt_cnt_pct}()},
\code{\link{fmt_mean_sd}()},
\code{\link{fmt_median}()},
\code{\link{fmt_n}()},
\code{\link{fmt_quantile_range}()}
}
\concept{helpers}
