% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{integrate0}
\alias{integrate0}
\title{Integration}
\usage{
integrate0(f, lower, upper, args)
}
\arguments{
\item{f}{Function to integrate.}

\item{lower}{Lower limit of integral.}

\item{upper}{Upper limit of integral.}

\item{args}{List of additional arguments from the function \code{integrate_args}.}
}
\value{
A list with the form of a \code{integrate_result} described in section
"Integration" of the package vignette.
}
\description{
Compute the integral \eqn{\int_a^b f(x) dx}.
}
\examples{
f = function(x) { exp(-x^2 / 2) }
args = integrate_args()
integrate0(f, 0, 10, args)

}
