% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{jacobian0}
\alias{jacobian0}
\title{Numerical Jacobian Matrix}
\usage{
jacobian0(f, x, args)
}
\arguments{
\item{f}{Function to differentiate.}

\item{x}{Vector at which to evaluate the Jacobian.}

\item{args}{List of additional arguments from the function \code{richardson_args}.}
}
\value{
A list with the form of a \code{jacobian_result} described in section "Jacobian"
of the package vignette.
}
\description{
Numerical Jacobian Matrix
}
\examples{
f = function(x) { cumsum(sin(x)) }
x0 = seq(1, 10, length.out = 5)
args = richardson_args()
out = jacobian0(f, x0, args)
print(out$value)
numDeriv::jacobian(f, x0)

}
