% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foghorn.R
\name{summary_cran_results}
\alias{summary_cran_results}
\title{Summary of the CRAN check results}
\usage{
summary_cran_results(email = NULL, pkg = NULL, compact = FALSE, ...)
}
\arguments{
\item{email}{email address for package maintainers (character
vector)}

\item{pkg}{package names (character vector)}

\item{compact}{if \code{TRUE}, all the packages with non-OK
results are listed in a single line, otherwise they are listed
on multiple lines.}

\item{...}{additional arguments to control where the data from the
check results are coming from and how they are downloaded from
the CRAN servers (see Details section).}
}
\value{
Prints the packages that return errors, warnings, and
    notes on the CRAN platforms. The number in parenthesis after
    the name of the packages indicates the number of CRAN
    platforms that produce these results.
}
\description{
Given the email address of a package maintainer, and/or a vector
of package names, it displays at the console a summary of the
check results run on the CRAN platforms. This function is designed
to be included in your .Rprofile to be run (periodically) at start
up.
}
\examples{
\dontrun{
   summary_cran_results(email = c("user1@company1.com", "user2@company2.com"))
   summary_cran_results(email = "user1@company1.com",
                        pkg = c("pkg1", "pkg2"))
}
}
