% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fG_ssm.R
\name{plot.fG_ssm}
\alias{plot.fG_ssm}
\title{plot}
\usage{
\method{plot}{fG_ssm}(
  x,
  what = c("fitted", "predicted"),
  type = 1,
  outlier = TRUE,
  pages = 1,
  ncol = 2,
  ...
)
}
\arguments{
\item{x}{a \code{foieGras} ssm fit object with class `fG_ssm`}

\item{what}{specify which location estimates to display on time-series plots: fitted or predicted}

\item{type}{of plot to generate: 1-d time series for lon and lat separately (type = 1, default) or 2-d track plot (type = 2)}

\item{outlier}{include outlier locations dropped by prefilter (outlier = TRUE, default)}

\item{pages}{plots of all individuals on a single page (pages = 1; default) or each individual on a separate page (pages = 0)}

\item{ncol}{number of columns to use for faceting. Default is ncol = 2 but this may be increased for multi-individual fit objects}

\item{...}{additional arguments to be ignored}
}
\value{
a ggplot object with either: (type = 1) 1-d time series of fits to data, 
separated into x and y components (units = km) with prediction uncertainty ribbons (2 x SE); 
or (type = 2) 2-d fits to data (units = km)
}
\description{
visualize fits from an fG_ssm object
}
\examples{
## load example foieGras fit object (to save time)
data(xs)
plot(xs, what = "f", type = 1)
plot(xs, what = "p", type = 2)

}
