% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grab.R
\name{grab}
\alias{grab}
\title{grab tibble's by name from a foieGras model object}
\usage{
grab(x, what = "fitted", as_sf = TRUE)
}
\arguments{
\item{x}{a \code{foieGras} ssm or mpm model object}

\item{what}{the tibble to be grabbed; either \code{fitted}, \code{predicted} (ssm only), or
\code{data} (single letters can be used)}

\item{as_sf}{logical; if FALSE then return a tibble with un-projected lonlat
coordinates, otherwise return an sf tibble. Ignored if x is an mpm model object.}
}
\value{
a tibble with all individual tibble's appended
}
\description{
\code{grab()} lets you obtain \code{fitted}, \code{predicted}, or \code{data} tibble's
from a compound tibble created when fitting to multiple individual data sets.
The specified tibble's are appended to a single output tibble.
}
\examples{
## load example foieGras fit object (to save time)
data(xs)
## grab predicted values as an un-projected tibble
preds <- grab(xs, what = "predicted", as_sf = FALSE)

}
