% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font-getters.R
\name{font_variants}
\alias{font_styles}
\alias{font_variants}
\title{Font variants}
\usage{
font_variants(fontset)

font_styles(fontset, variant)
}
\arguments{
\item{fontset}{A string giving the name of a set of fonts
(e.g. \code{"Liberation"} or\code{"Bitstream Vera"}). Use
\code{\link{fontset_list}()} to obtain the list of fontsets
registered in your session.}

\item{variant}{Font variant, as per Fontconfig's nomenclature. Use
\code{\link{fontset_variants}()} to find out which variants are
available for a fontset.}
}
\description{
\code{font_variants()} returns a tree of fonts organised as per
fontconfig's nomenclature. The first level contains variants of a
font and the second level contains font styles.
}
\details{
See also \code{\link{font_families}()} and \code{\link{font_faces}()}
for similar collections organised according to R nomenclature of
fonts. Note that variants and styles are a super set of R families
and faces and may contain more fonts.
}
\examples{
font_variants("Bitstream Vera")
font_variants("Bitstream Vera")$Sans$Oblique
font_styles("Bitstream Vera", "Sans")
}
\seealso{
\code{\link{font_families}()}, \code{\link{fonts}()}
}

